\name{modified_soar_stroke_score}
\alias{modified_soar_stroke_score}
\title{
Modified SOAR Score for Stroke
}
\description{
Calculates the Modified SOAR (mSOAR) Score to predict short-term (inpatient) mortality in patients with acute stroke. The score incorporates Stroke type, Oxfordshire Community Stroke Project (OCSP) classification, Age, pre-stroke modified Rankin Scale (mRS), and admission NIHSS score.
}
\usage{
modified_soar_stroke_score(stroke_type, ocsp_classification, age, pre_stroke_mrs,
                           nihss_score)
}
\arguments{
  \item{stroke_type}{
String. Type of stroke: "infarct" (0 pts) or "hemorrhage" (1 pt).
}
  \item{ocsp_classification}{
String. Oxfordshire Community Stroke Project classification.
"lacs": Lacunar syndrome (0 pts).
"pacs": Partial anterior circulation syndrome (0 pts).
"pocs": Posterior circulation syndrome (1 pt).
"tacs": Total anterior circulation syndrome (2 pts).
}
  \item{age}{
Numeric. Patient age in years.
<= 65: 0 pts.
66-85: 1 pt.
> 85: 2 pts.
}
  \item{pre_stroke_mrs}{
Numeric. Pre-stroke Modified Rankin Scale score (0-5).
0-2: 0 pts.
3-4: 1 pt.
5: 2 pts.
}
  \item{nihss_score}{
Numeric. Admission NIH Stroke Scale score.
0-4: 0 pts.
5-10: 1 pt.
>= 11: 2 pts.
}
}
\value{
A list containing:
\item{mSOAR_Score}{The calculated score (Range 0-9).}
\item{Est_Inpatient_Mortality}{Estimated probability of inpatient mortality based on derivation cohorts.}
}
\references{
Myint PK, Clark AB, Kwok CS, et al. The SOAR (Stroke subtype, Oxfordshire Community Stroke Project classification, Age, pre-stroke modified Rankin) score in predicting early mortality post-stroke. Top Stroke Rehabil. 2014;21(1):34-41.
Abdul-Rahim AH, Quinn TJ, Alder S, et al. Derivation and Validation of a Novel Prognostic Scale (Modified-SOAR) to Predict Early Mortality in Acute Stroke. Stroke. 2016;47(3):742-747. doi:10.1161/STROKEAHA.115.011630
}
\examples{

# Example 1: Low Risk
# Infarct (0), LACS (0), 60yo (0), mRS 0 (0), NIHSS 3 (0)
# Score = 0
modified_soar_stroke_score("infarct", "lacs", 60, 0, 3)

# Example 2: High Risk
# Hemorrhage (1), TACS (2), 87yo (2), mRS 4 (1), NIHSS 15 (2)
# Score = 8
modified_soar_stroke_score("hemorrhage", "tacs", 87, 4, 15)
}
