\name{montreal_ibd_classification}
\alias{montreal_ibd_classification}
\title{
Montreal Classification for Inflammatory Bowel Disease
}
\description{
Generates the Montreal Classification code for Crohn's Disease (CD) or Ulcerative Colitis (UC). For CD, it classifies based on Age at diagnosis (A), Location (L), and Behavior (B). For UC, it classifies based on Extent (E) and Severity (S).
}
\usage{
montreal_ibd_classification(disease_type, age_years = NULL, cd_location = NULL,
                            cd_behavior = NULL, cd_upper_gi = 0, cd_perianal = 0,
                            uc_extent = NULL, uc_severity = NULL)
}
\arguments{
  \item{disease_type}{
String. "crohns" or "uc".
}
  \item{age_years}{
Numeric. Age at diagnosis (Required for Crohn's).
A1: <17, A2: 17-40, A3: >40.
}
  \item{cd_location}{
String. Disease location (Crohn's).
"ileal" (L1), "colonic" (L2), "ileocolonic" (L3).
}
  \item{cd_behavior}{
String. Disease behavior (Crohn's).
"non_stricturing_non_penetrating" (B1), "stricturing" (B2), "penetrating" (B3).
}
  \item{cd_upper_gi}{
Numeric (0 or 1). Involvement of upper GI tract (L4 modifier). (1 = Yes).
}
  \item{cd_perianal}{
Numeric (0 or 1). Perianal disease modifier (p). (1 = Yes).
}
  \item{uc_extent}{
String. Extent of disease (UC).
"proctitis" (E1), "left_sided" (E2), "extensive" (E3).
}
  \item{uc_severity}{
String. Disease severity (UC).
"remission" (S0), "mild" (S1), "moderate" (S2), "severe" (S3).
}
}
\value{
A list containing:
\item{Classification_Code}{The resulting Montreal classification string (e.g., "A2 L1 B1" or "E2 S1").}
}
\references{
Satsangi J, Silverberg MS, Vermeire S, Colombel JF. The Montreal classification of inflammatory bowel disease: controversies, consensus, and implications. Gut. 2006;55(6):749-753. doi:10.1136/gut.2005.082909
}
\examples{

# Example 1: Crohn's Disease
# 25yo, Ileal, Stricturing, No upper/perianal
montreal_ibd_classification("crohns", 25, "ileal", "stricturing", 0, 0)

# Example 2: Crohn's with modifiers
# 16yo, Colonic, Penetrating, Perianal disease present
montreal_ibd_classification("crohns", 16, "colonic", "penetrating", 0, 1)

# Example 3: Ulcerative Colitis
# Left-sided, Moderate severity
montreal_ibd_classification("uc", uc_extent = "left_sided", uc_severity = "moderate")
}
