\name{pecarn_head_injury_rule}
\alias{pecarn_head_injury_rule}
\title{
PECARN Pediatric Head Injury/Trauma Algorithm
}
\description{
Calculates the risk of clinically important Traumatic Brain Injury (ciTBI) in children with minor head trauma (GCS 14-15) using the PECARN prediction rules. The algorithm stratifies patients into Low, Intermediate, or High risk groups to guide the decision for head CT imaging versus observation. There are separate criteria for children < 2 years and those >= 2 years.
}
\usage{
pecarn_head_injury_rule(age_years, gcs_score, altered_mental_status,
                        signs_of_skull_fracture, severe_mechanism_of_injury,
                        loc_duration_seconds = 0, not_acting_normally = 0,
                        non_frontal_scalp_hematoma = 0, history_of_vomiting = 0,
                        severe_headache = 0)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years. Determines which algorithm branch to use (<2 or >=2).
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score.
}
  \item{altered_mental_status}{
Numeric (0 or 1). Agitation, somnolence, repetitive questioning, or slow response to verbal communication. (1 = Yes).
}
  \item{signs_of_skull_fracture}{
Numeric (0 or 1). Palpable fracture (if <2y) or signs of basilar skull fracture (if >=2y). (1 = Yes).
}
  \item{severe_mechanism_of_injury}{
Numeric (0 or 1). MVC with ejection/death/rollover, ped/bike vs auto, fall >3ft (<2y) or >5ft (>=2y), or head struck by high-impact object. (1 = Yes).
}
  \item{loc_duration_seconds}{
Numeric. Duration of loss of consciousness in seconds. (If > 0, counts as LOC history for >=2y. If > 5, counts as LOC criterion for <2y).
}
  \item{not_acting_normally}{
Numeric (0 or 1). [Only for < 2y] Is the child acting normally per parent? (1 = No/Not acting normally).
}
  \item{non_frontal_scalp_hematoma}{
Numeric (0 or 1). [Only for < 2y] Presence of non-frontal scalp hematoma. (1 = Yes).
}
  \item{history_of_vomiting}{
Numeric (0 or 1). [Only for >= 2y] History of vomiting. (1 = Yes).
}
  \item{severe_headache}{
Numeric (0 or 1). [Only for >= 2y] Severe headache. (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Group}{Classification (Low, Intermediate, High).}
\item{Risk_of_ciTBI}{Estimated risk of clinically important TBI.}
\item{Recommendation}{Guidance on CT imaging vs. observation.}
}
\references{
Kuppermann N, Holmes JF, Dayan PS, et al. Identification of children at very low risk of clinically-important brain injuries after head trauma: a prospective cohort study. Lancet. 2009;374(9696):1160-1170. doi:10.1016/S0140-6736(09)61550-6
}
\examples{

# Example 1: Child < 2 years, High Risk
# GCS 14, AMS
pecarn_head_injury_rule(1.5, 14, 1, 0, 0)

# Example 2: Child >= 2 years, Intermediate Risk
# 5yo, Vomiting, Normal GCS, No other signs
pecarn_head_injury_rule(5, 15, 0, 0, 0, history_of_vomiting = 1)

# Example 3: Child >= 2 years, Low Risk
# 8yo, No symptoms/signs
pecarn_head_injury_rule(8, 15, 0, 0, 0)
}
