\name{prognostic_index_cancer}
\alias{prognostic_index_cancer}
\title{
Prognostic Index (PI) for Cancer Outcomes
}
\description{
Calculates the Prognostic Index (PI), an inflammation-based score used to predict survival in patients with various types of cancer. It is derived from C-reactive protein (CRP) levels and White Blood Cell (WBC) count.
}
\usage{
prognostic_index_cancer(crp_mg_l, wbc_count_x10_9_l)
}
\arguments{
  \item{crp_mg_l}{
Numeric. Serum C-Reactive Protein level in mg/L.
}
  \item{wbc_count_x10_9_l}{
Numeric. White Blood Cell count in x10^9/L.
}
}
\details{
The PI is scored as follows:
\itemize{
  \item \strong{Score 0}: CRP <= 10 mg/L AND WBC <= 11 x 10^9/L.
  \item \strong{Score 1}: CRP > 10 mg/L OR WBC > 11 x 10^9/L (but not both).
  \item \strong{Score 2}: CRP > 10 mg/L AND WBC > 11 x 10^9/L.
}
}
\value{
A list containing:
\item{PI_Score}{The calculated index score (0, 1, or 2).}
\item{Prognosis_Group}{Risk classification (Good, Intermediate, Poor).}
}
\references{
Kasahara A, et al. Clinicopathological biomarkers in advanced lung cancer.
Proctor MJ, Morrison DS, Talwar D, et al. A comparison of inflammation-based prognostic scores in patients with cancer. A Glasgow Inflammation Outcome Study. Eur J Cancer. 2011;47(17):2633-2641. doi:10.1016/j.ejca.2011.03.028
}
\examples{

# Example 1: Good Prognosis
# CRP 5, WBC 8
# Score = 0
prognostic_index_cancer(5, 8)

# Example 2: Poor Prognosis
# CRP 20, WBC 15
# Score = 2
prognostic_index_cancer(20, 15)
}
