\name{rai_cll_staging}
\alias{rai_cll_staging}
\title{
Rai Staging System for Chronic Lymphocytic Leukemia (CLL)
}
\description{
Calculates the Rai Stage for patients with Chronic Lymphocytic Leukemia (CLL). This staging system stratifies patients into Low, Intermediate, and High risk groups based on the presence of lymphocytosis, lymphadenopathy, organomegaly (hepatomegaly or splenomegaly), anemia, and thrombocytopenia.
}
\usage{
rai_cll_staging(lymphocytosis, lymphadenopathy, organomegaly,
                hemoglobin_lt_11, platelets_lt_100)
}
\arguments{
  \item{lymphocytosis}{
Numeric (0 or 1). Presence of absolute lymphocytosis (>5,000/uL in blood and >=30\% in marrow). (1 = Yes).
}
  \item{lymphadenopathy}{
Numeric (0 or 1). Presence of lymphadenopathy. (1 = Yes).
}
  \item{organomegaly}{
Numeric (0 or 1). Presence of hepatomegaly or splenomegaly. (1 = Yes).
}
  \item{hemoglobin_lt_11}{
Numeric (0 or 1). Hemoglobin < 11 g/dL (Anemia). (1 = Yes).
}
  \item{platelets_lt_100}{
Numeric (0 or 1). Platelets < 100,000/uL (Thrombocytopenia). (1 = Yes).
}
}
\value{
A list containing:
\item{Rai_Stage}{The calculated stage (0, I, II, III, or IV).}
\item{Risk_Category}{Risk stratification (Low, Intermediate, High).}
\item{Median_Survival}{Historical median survival estimates based on the original 1975 cohort data.}
}
\references{
Rai KR, Sawitsky A, Cronkite EP, et al. Clinical staging of chronic lymphocytic leukemia. Blood. 1975;46(2):219-234.
}
\examples{

# Example 1: High Risk (Stage IV)
# Lymphocytosis, Anemia, Thrombocytopenia
rai_cll_staging(1, 1, 1, 1, 1)

# Example 2: Low Risk (Stage 0)
# Lymphocytosis only
rai_cll_staging(1, 0, 0, 0, 0)
}
