\name{rapid_pleural_infection_score}
\alias{rapid_pleural_infection_score}
\title{
RAPID Score for Pleural Infection
}
\description{
Calculates the RAPID Score to predict 3-month mortality in patients with pleural infection. The acronym RAPID stands for Renal (BUN), Age, Purulence, Infection Source, and Diet (Albumin).
}
\usage{
rapid_pleural_infection_score(bun, age, purulent_fluid, hospital_acquired,
                              albumin, bun_units = "mg/dL", albumin_units = "g/dL")
}
\arguments{
  \item{bun}{
Numeric. Blood Urea Nitrogen level.
<14 mg/dL: 0 pts.
14-23 mg/dL: 1 pt.
>23 mg/dL: 2 pts.
}
  \item{age}{
Numeric. Patient age in years.
<50: 0 pts.
50-70: 1 pt.
>70: 2 pts.
}
  \item{purulent_fluid}{
Numeric (0 or 1). Is the pleural fluid purulent? (1 = Yes, 0 = No). Note: Non-purulent fluid adds 1 point.
}
  \item{hospital_acquired}{
Numeric (0 or 1). Is the infection hospital-acquired? (1 = Yes, +1 pt).
}
  \item{albumin}{
Numeric. Serum Albumin level. (<2.7 g/dL adds 1 point).
}
  \item{bun_units}{
String. Units for BUN. "mg/dL" (default) or "mmol/L".
}
  \item{albumin_units}{
String. Units for Albumin. "g/dL" (default) or "g/L".
}
}
\value{
A list containing:
\item{RAPID_Score}{The calculated total score (Range 0-7).}
\item{Risk_Category}{Classification (Low 0-2, Medium 3-4, High 5-7).}
\item{Est_3_Month_Mortality}{Estimated 3-month mortality percentage.}
}
\references{
Rahman NM, Maskell NA, West A, et al. Intrapleural use of tissue plasminogen activator and DNase in pleural infection. N Engl J Med. 2011;365(6):518-526. doi:10.1056/NEJMoa1012740
White HD, Henry C, Stockgmayer S, et al. A Proposal for a New Scoring System to Predict Mortality in Patients With Pleural Infection. Chest. 2015;148:19S.
}
\examples{

# Example 1: Low Risk
# BUN 10, Age 40, Purulent(Yes), Community(0), Alb 3.5
# Score = 0 + 0 + 0 + 0 + 0 = 0
rapid_pleural_infection_score(10, 40, 1, 0, 3.5)

# Example 2: High Risk
# BUN 30 (+2), Age 75 (+2), Non-purulent (+1), Hospital (+1), Alb 2.0 (+1)
# Score = 7
rapid_pleural_infection_score(30, 75, 0, 1, 2.0)
}
