\name{reach_b_score}
\alias{reach_b_score}
\title{
REACH-B Score for Hepatocellular Carcinoma (HCC) Risk
}
\description{
Calculates the REACH-B (Risk Estimation for Hepatocellular Carcinoma in Chronic Hepatitis B) score. This tool estimates the risk of developing HCC at 3, 5, and 10 years in patients with chronic hepatitis B without cirrhosis. It incorporates gender, age, ALT levels, HBeAg status, and serum HBV DNA levels.
}
\usage{
reach_b_score(sex, age, alt_u_l, hbeag_positive, hbv_dna, dna_units = "IU/mL")
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). Male adds 2 points.
}
  \item{age}{
Numeric. Patient age in years. (Points range from 0 for 30-34y to 7 for >=65y).
}
  \item{alt_u_l}{
Numeric. Serum Alanine Aminotransferase (ALT) level in U/L. (<15: 0, 15-44: 1, >=45: 2).
}
  \item{hbeag_positive}{
Numeric (0 or 1). Hepatitis B e-Antigen status. (1 = Positive, +2 points).
}
  \item{hbv_dna}{
Numeric. Serum HBV DNA level.
}
  \item{dna_units}{
String. Units for HBV DNA input. Options: "IU/mL" (default) or "copies/mL". (Conversion: 1 IU/mL approx 5 copies/mL).
}
}
\value{
A list containing:
\item{REACH_B_Score}{The calculated risk score (Range 0-17).}
\item{HCC_Risk_3_Year}{Estimated 3-year risk of developing HCC.}
\item{HCC_Risk_5_Year}{Estimated 5-year risk of developing HCC.}
\item{HCC_Risk_10_Year}{Estimated 10-year risk of developing HCC.}
}
\references{
Yang HI, Yuen MF, Chan HL, et al. Risk estimation for hepatocellular carcinoma in chronic hepatitis B (REACH-B): development and validation of a predictive score. Lancet Oncol. 2011;12(6):568-574. doi:10.1016/S1470-2045(11)70077-8
}
\examples{

# Example 1: High Risk Male
# 50yo, ALT 50, HBeAg+, DNA 10^6 copies/mL
# Score: Male(2) + Age 50(4) + ALT(2) + HBeAg(2) + DNA(4) = 14
reach_b_score("male", 50, 50, 1, 1000000, "copies/mL")

# Example 2: Low Risk Female
# 35yo, ALT 10, HBeAg-, DNA 2000 IU/mL (10^4 copies)
# Score: Female(0) + Age 35(1) + ALT(0) + HBeAg(0) + DNA(3) = 4
reach_b_score("female", 35, 10, 0, 2000, "IU/mL")
}
