\name{riske_score_cardiac_surgery}
\alias{riske_score_cardiac_surgery}
\title{
RISK-E Score for Cardiac Surgery in Active Infective Endocarditis
}
\description{
Calculates the RISK-E score to predict in-hospital mortality for patients with active infective endocarditis undergoing cardiac surgery. The score is derived from preoperative variables including age, shock (cardiogenic/septic), immunosuppression, renal function, pathogen (S. aureus), and valve characteristics.
}
\usage{
riske_score_cardiac_surgery(age, shock_cardiogenic, shock_septic,
                            immunosuppression, kidney_injury,
                            staphylococcus_aureus, acute_renal_failure_preop,
                            prostheses_involved_count, aortic_valve_involved)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{shock_cardiogenic}{
Numeric (0 or 1). Presence of cardiogenic shock. (1 = Yes, +6 pts).
}
  \item{shock_septic}{
Numeric (0 or 1). Presence of septic shock. (1 = Yes, +11 pts).
}
  \item{immunosuppression}{
Numeric (0 or 1). Immunosuppressed status. (1 = Yes, +4 pts).
}
  \item{kidney_injury}{
Numeric (0 or 1). History of kidney injury or chronic kidney disease. (1 = Yes, +5 pts).
}
  \item{staphylococcus_aureus}{
Numeric (0 or 1). Causative organism is Staphylococcus aureus. (1 = Yes, +6 pts).
}
  \item{acute_renal_failure_preop}{
Numeric (0 or 1). Presence of acute renal failure preoperatively. (1 = Yes, +5 pts).
}
  \item{prostheses_involved_count}{
Numeric. Number of prosthetic valves involved/infected. (>=1 adds 6 pts).
}
  \item{aortic_valve_involved}{
Numeric (0 or 1). Involvement of the aortic valve. (1 = Yes, +4 pts).
}
}
\value{
A list containing:
\item{RISKE_Score}{The calculated total score (Range 0-~60).}
\item{Risk_Category}{Classification (Low, Intermediate, High, Very High).}
\item{Est_InHospital_Mortality}{Estimated in-hospital mortality percentage range.}
}
\references{
Olmos C, Vilacosta I, Habib G, et al. Risk score for cardiac surgery in active infective endocarditis. Heart. 2017;103(18):1435-1442. doi:10.1136/heartjnl-2016-311093
}
\examples{

# Example 1: High Risk
# 65yo (+9), Septic Shock (+11), S. aureus (+6), Aortic Valve (+4)
# Score = 30
riske_score_cardiac_surgery(65, 0, 1, 0, 0, 1, 0, 0, 1)

# Example 2: Low Risk
# 35yo (0), No shock, No organ failure, Mitral Valve (0)
# Score = 0
riske_score_cardiac_surgery(35, 0, 0, 0, 0, 0, 0, 0, 0)
}
