\name{rockall_score_complete}
\alias{rockall_score_complete}
\title{
Rockall Score for Upper GI Bleeding (Complete)
}
\description{
Calculates the complete Rockall Score to predict the risk of mortality and rebleeding in patients with upper gastrointestinal bleeding. This version requires endoscopic findings (diagnosis and stigmata of recent hemorrhage).
}
\usage{
rockall_score_complete(age, systolic_bp, heart_rate, comorbidity_category,
                       diagnosis_category, major_stigmata_present)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{comorbidity_category}{
String. Major comorbidities.
"none": No major comorbidity (0 pts).
"cardiac_other": Heart failure, ischemic heart disease, or other major morbidity (2 pts).
"renal_liver_metastatic": Renal failure, liver failure, or metastatic cancer (3 pts).
}
  \item{diagnosis_category}{
String. Diagnosis determined by endoscopy.
"mallory_weiss_none": Mallory-Weiss tear or no lesion identified (0 pts).
"all_other": All other diagnoses (e.g., ulcers, erosions, esophagitis) (1 pt).
"malignancy": Malignancy of the upper GI tract (2 pts).
}
  \item{major_stigmata_present}{
Numeric (0 or 1). Presence of major stigmata of recent hemorrhage (blood in upper GI tract, adherent clot, visible or spurting vessel). (1 = Yes, +2 pts). Note: Clean base or dark spot only is 0 pts.
}
}
\value{
A list containing:
\item{Rockall_Score}{The calculated score (Range 0-11).}
\item{Mortality_Risk}{Estimated mortality risk percentage.}
\item{Rebleed_Risk}{Estimated rebleeding risk percentage.}
}
\references{
Rockall TA, Logan RF, Devlin HB, Northfield TC. Risk assessment after acute upper gastrointestinal haemorrhage. Gut. 1996;38(3):316-321. doi:10.1136/gut.38.3.316
}
\examples{

# Example 1: High Risk
# 70yo (+1), SBP 95 (+2), Renal Failure (+3), Ulcer (+1), Visible Vessel (+2)
# Score = 9
rockall_score_complete(70, 95, 100, "renal_liver_metastatic", "all_other", 1)

# Example 2: Low Risk
# 45yo (0), SBP 120 (0), No Comorbs (0), Mallory-Weiss (0), No Stigmata (0)
# Score = 0
rockall_score_complete(45, 120, 70, "none", "mallory_weiss_none", 0)
}
