\name{rome_ii_ibs_criteria}
\alias{rome_ii_ibs_criteria}
\title{
Rome II Diagnostic Criteria for Irritable Bowel Syndrome (IBS)
}
\description{
Evaluates the **Rome II criteria** for diagnosing Irritable Bowel Syndrome (IBS) in adults. Diagnosis requires recurrent abdominal pain or discomfort for at least 12 weeks (which need not be consecutive) in the preceding 12 months, along with two or more specific features related to pain relief, and changes in stool frequency or consistency. This classification system has been largely superseded by Rome III and Rome IV.
}
\usage{
rome_ii_ibs_criteria(abdominal_pain_discomfort_12mo, pain_relief_by_defecation,
                     pain_onset_associated_with_frequency_change,
                     pain_onset_associated_with_consistency_change,
                     no_structural_disease_excluded)
}
\arguments{
  \item{abdominal_pain_discomfort_12mo}{
Numeric (0 or 1). Recurrent abdominal pain or discomfort for at least 12 weeks in the past 12 months. (1 = Yes).
}
  \item{pain_relief_by_defecation}{
Numeric (0 or 1). Pain relieved by defecation. (1 = Yes).
}
  \item{pain_onset_associated_with_frequency_change}{
Numeric (0 or 1). Pain onset associated with a change in frequency of stool. (1 = Yes).
}
  \item{pain_onset_associated_with_consistency_change}{
Numeric (0 or 1). Pain onset associated with a change in stool consistency/appearance

[Image of bristol stool scale chart]
. (1 = Yes).
}
  \item{no_structural_disease_excluded}{
Numeric (0 or 1). After appropriate evaluation, are there **no** structural or organic diseases to explain the symptoms? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Irritable Bowel Syndrome (IBS)" or "Criteria Not Met".}
\item{IBS_Features_Count}{The number of positive associated features (max 3, requires >= 2 for diagnosis).}
}
\references{
Thompson WG, Longstreth GF, Drossman DA, et al. Functional bowel disorders and functional abdominal pain. Gut. 1999;45 Suppl 2:II43-7.
}
\examples{

# Example 1: Diagnosis Met
# Pain 12mo (1), Pain relief by defecation (1), Change frequency (1), Change consistency (0)
# Result: Meets Criteria (2 features met)
rome_ii_ibs_criteria(1, 1, 1, 0, 1)

# Example 2: Not Met (Insufficient features)
# Pain 12mo (1), Only Pain relief by defecation (1)
# Result: Criteria Not Met (Only 1 feature met)
rome_ii_ibs_criteria(1, 1, 0, 0, 1)
}
