\name{rome_iv_functional_anorectal_pain}
\alias{rome_iv_functional_anorectal_pain}
\title{
Rome IV Diagnostic Criteria for Functional Anorectal Pain
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Anorectal Pain disorders, specifically distinguishing between Levator Ani Syndrome and Unspecified Functional Anorectal Pain. Diagnosis requires chronic/recurrent rectal pain lasting at least 30 minutes, exclusion of organic causes, and symptom chronicity (onset >= 6 months, active >= 3 months).
}
\usage{
rome_iv_functional_anorectal_pain(chronic_rectal_pain, duration_ge_30_min,
                                  tenderness_puborectalis, organic_causes_excluded,
                                  symptom_onset_ge_6_months,
                                  symptoms_active_last_3_months)
}
\arguments{
  \item{chronic_rectal_pain}{
Numeric (0 or 1). Presence of chronic or recurrent rectal pain or aching. (1 = Yes).
}
  \item{duration_ge_30_min}{
Numeric (0 or 1). Do episodes last 30 minutes or longer? (1 = Yes).
}
  \item{tenderness_puborectalis}{
Numeric (0 or 1). Is there tenderness during posterior traction on the puborectalis muscle? (1 = Yes). Used to differentiate Levator Ani Syndrome from Unspecified Functional Anorectal Pain.
}
  \item{organic_causes_excluded}{
Numeric (0 or 1). Have other causes (e.g., ischemia, inflammatory bowel disease, cryptitis, hemorrhoids, anal fissures, tumor) been excluded? (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptoms start at least 6 months ago? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{Diagnostic result ("Levator Ani Syndrome", "Unspecified Functional Anorectal Pain", or "Criteria Not Met").}
}
\references{
Rao SS, Bharucha AE, Chiarioni G, et al. Anorectal Disorders. Gastroenterology. 2016;150:1430-1442. doi:10.1053/j.gastro.2016.02.009
}
\examples{

# Example 1: Levator Ani Syndrome
# Chronic pain (1), >30 min (1), Tenderness (1), Exclusions (1), Chronicity (1,1)
rome_iv_functional_anorectal_pain(1, 1, 1, 1, 1, 1)

# Example 2: Unspecified Functional Anorectal Pain
# Chronic pain (1), >30 min (1), No tenderness (0), Exclusions (1), Chronicity (1,1)
rome_iv_functional_anorectal_pain(1, 1, 0, 1, 1, 1)

# Example 3: Criteria Not Met (Duration too short)
# Pain <30 min (0)
rome_iv_functional_anorectal_pain(1, 0, 1, 1, 1, 1)
}
