\name{score_4peps}
\alias{score_4peps}
\title{
4-Level Pulmonary Embolism Clinical Probability Score (4PEPS)
}
\description{
Calculates the 4PEPS score to stratify the clinical probability of pulmonary embolism (PE). This scoring system integrates clinical variables to assign patients into one of four risk categories (Very Low, Low, Moderate, High), each with a specific diagnostic strategy involving D-dimer testing cutoffs or imaging.
}
\usage{
score_4peps(age, sex, chronic_resp_disease, heart_rate_lt_80,
            chest_pain_and_dyspnea, estrogen_use, history_vte,
            syncope, immobility_4wks, o2_sat_lt_95,
            calf_pain_unilateral_edema, pe_most_likely)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
(<50 years = -2 points; 50-64 years = -1 point; >=65 years = 0 points).
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
(Male = +2 points; Female = 0 points).
}
  \item{chronic_resp_disease}{
Numeric (0 or 1). History of chronic respiratory disease.
(Yes = -1 point).
}
  \item{heart_rate_lt_80}{
Numeric (0 or 1). Heart rate < 80 bpm.
(Yes = -1 point).
}
  \item{chest_pain_and_dyspnea}{
Numeric (0 or 1). Presence of BOTH chest pain AND acute dyspnea.
(Yes = +1 point).
}
  \item{estrogen_use}{
Numeric (0 or 1). Current estrogen use (contraception or replacement).
(Yes = +2 points).
}
  \item{history_vte}{
Numeric (0 or 1). Prior history of VTE (DVT or PE).
(Yes = +2 points).
}
  \item{syncope}{
Numeric (0 or 1). History of syncope related to current event.
(Yes = +2 points).
}
  \item{immobility_4wks}{
Numeric (0 or 1). Immobility (bedridden >3 days, surgery, or lower limb cast) within the last 4 weeks.
(Yes = +2 points).
}
  \item{o2_sat_lt_95}{
Numeric (0 or 1). O2 saturation < 95\% on room air.
(Yes = +3 points).
}
  \item{calf_pain_unilateral_edema}{
Numeric (0 or 1). Calf pain and/or unilateral lower limb edema.
(Yes = +3 points).
}
  \item{pe_most_likely}{
Numeric (0 or 1). Pulmonary Embolism is the most likely diagnosis.
(Yes = +5 points).
}
}
\value{
A list containing:
\item{Score}{Total 4PEPS score.}
\item{Risk_Category}{Clinical probability category (Very Low, Low, Moderate, High).}
\item{Management_Strategy}{Recommended diagnostic action (e.g., rule out without testing, specific D-dimer cutoff, or imaging).}
}
\references{
Roy PM, et al. Derivation and Validation of a 4-Level Clinical Pretest Probability Score for Suspected Pulmonary Embolism to Safely Decrease Imaging Testing. JAMA Cardiol. 2021;6(6):669-677. doi:10.1001/jamacardio.2021.0064
}
\examples{

# Example 1: Very Low Risk
# 35yo Female (-2), HR < 80 (-1), No other risks -> Score -3
score_4peps(35, "female", 0, 1, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Moderate Risk
# 55yo Male (-1 + 2), Chest Pain/Dyspnea (+1), PE Most Likely (+5) -> Score 7
score_4peps(55, "male", 0, 0, 1, 0, 0, 0, 0, 0, 0, 1)

# Example 3: High Risk
# 70yo Female (0), Immobility (+2), O2 <95\% (+3),
#Unilateral Edema (+3), PE Most Likely (+5) -> Score 13
score_4peps(70, "female", 0, 0, 0, 0, 0, 0, 1, 1, 1, 1)
}
