\name{sex_shock_score}
\alias{sex_shock_score}
\title{
SEX-SHOCK Risk Score for Cardiogenic Shock in ACS
}
\description{
Calculates the SEX-SHOCK Risk Score to predict the risk of developing in-hospital cardiogenic shock (CS) in patients admitted with Acute Coronary Syndrome (ACS) treated with PCI. This score was developed to address sex-specific disparities in risk prediction, outperforming the ORBI score in women by incorporating biomarkers (CRP, Creatinine) and LVEF alongside traditional factors.
}
\usage{
sex_shock_score(sex, age, st_segment_elevation, lvef_category, creatinine, crp,
                creatinine_units = "mg/dL")
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years.
}
  \item{st_segment_elevation}{
Numeric (0 or 1). Presence of ST-segment elevation on presenting ECG (i.e., STEMI). (1 = Yes).
}
  \item{lvef_category}{
String. Left Ventricular Ejection Fraction category.
"lt_35": < 35\%.
"35_50": 35-50\%.
"gt_50": > 50\%.
}
  \item{creatinine}{
Numeric. Serum creatinine level on admission.
}
  \item{crp}{
Numeric. C-Reactive Protein level on admission (mg/L).
}
  \item{creatinine_units}{
String. Units for creatinine input. Options: "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{Inputs}{A summary of the patient variables provided for risk stratification.}
\item{Message}{Information regarding the model source (Wang et al., 2024).}
}
\references{
Wang W, et al. Sex-specific prediction of cardiogenic shock after acute coronary syndromes: the SEX-SHOCK score. Eur Heart J. 2024. doi:10.1093/eurheartj/ehae593
}
\examples{
# Example: 65yo Female with STEMI, LVEF 40%, Cr 1.0, CRP 15
sex_shock_score("female", 65, 1, "35_50", 1.0, 15, "mg/dL")
}
