\name{sokal_cml_index}
\alias{sokal_cml_index}
\title{
Sokal Index for Chronic Myelogenous Leukemia (CML)
}
\description{
Calculates the Sokal Index to prognosticate risk in patients with Chronic Myelogenous Leukemia (CML). The score is based on age, spleen size, platelet count, and percentage of blasts in the peripheral blood. It stratifies patients into Low, Intermediate, or High risk groups regarding survival.
}
\usage{
sokal_cml_index(age, spleen_size_cm, platelet_count, blasts_percent)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{spleen_size_cm}{
Numeric. Spleen size in centimeters below the costal margin (0 if not palpable).
}
  \item{platelet_count}{
Numeric. Platelet count in x10^9/L (e.g., 300 for 300,000/uL).
}
  \item{blasts_percent}{
Numeric. Percentage of blasts in peripheral blood.
}
}
\value{
A list containing:
\item{Sokal_Score}{The calculated relative risk score.}
\item{Risk_Group}{Risk classification (Low < 0.8, Intermediate 0.8-1.2, High > 1.2).}
}
\references{
Sokal JE, Cox EB, Baccarani M, et al. Prognostic discrimination in "good-risk" chronic granulocytic leukemia. Blood. 1984;63(4):789-799.
}
\examples{

# Example 1: Low Risk
# 35yo, Spleen 0cm, Plt 300, Blasts 1%
# Score approx 0.6
sokal_cml_index(35, 0, 300, 1)

# Example 2: High Risk
# 60yo, Spleen 10cm, Plt 700, Blasts 5%
# Score > 1.2
sokal_cml_index(60, 10, 700, 5)
}
