\name{stanford_sleepiness_scale}
\alias{stanford_sleepiness_scale}
\title{
Stanford Sleepiness Scale (SSS)
}
\description{
Retrieves the description and interpretation for the Stanford Sleepiness Scale (SSS) score. The SSS is a self-rating scale used to quantify a person's current level of alertness or sleepiness at a specific moment in time.
}
\usage{
stanford_sleepiness_scale(alertness_level)
}
\arguments{
  \item{alertness_level}{
Numeric (1-7). The selected rating corresponding to the patient's current state.
1: Feeling active, vital, alert, or wide awake
2: Functioning at high levels, but not at peak; able to concentrate
3: Awake, but relaxed; responsive but not fully alert
4: Somewhat foggy, let down
5: Foggy; losing interest in remaining awake; slowed down
6: Sleepy, woozy, fighting sleep; prefer to lie down
7: No longer fighting sleep, sleep onset soon; having dream-like thoughts
}
}
\value{
A list containing:
\item{SSS_Score}{The input score.}
\item{Description}{The specific descriptor associated with the score.}
\item{Interpretation}{General classification (Alert/Normal vs. Sleepy/Fatigued).}
}
\references{
Hoddes E, Zarcone V, Smythe H, Phillips R, Dement WC. Quantification of sleepiness: a new approach. Psychophysiology. 1973;10(4):431-436. doi:10.1111/j.1469-8986.1973.tb00801.x
}
\examples{

# Example 1: Alert
stanford_sleepiness_scale(2)

# Example 2: Sleepy
stanford_sleepiness_scale(6)
}
