\name{stumbl_battle_score}
\alias{stumbl_battle_score}
\title{
STUMBL (Battle) Score for Blunt Chest Wall Trauma
}
\description{
Calculates the STUMBL (STUdy of the Management of BLunt chest wall trauma) Score, also known as the Battle Score. This clinical decision rule predicts the risk of complications (e.g., pneumonia, pleural effusion, respiratory failure) in patients with blunt chest wall trauma to guide disposition (discharge vs. admission).
}
\usage{
stumbl_battle_score(age, num_rib_fractures, chronic_lung_disease,
                    anticoagulant_use, spo2_percent)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 65 years adds 5 points).
}
  \item{num_rib_fractures}{
Numeric. Number of rib fractures identified on imaging. (>= 3 adds 4 points).
}
  \item{chronic_lung_disease}{
Numeric (0 or 1). History of chronic lung disease (e.g., COPD, asthma). (1 = Yes, +5 points).
}
  \item{anticoagulant_use}{
Numeric (0 or 1). Pre-injury use of anticoagulants or antiplatelet medication. (1 = Yes, +4 points).
}
  \item{spo2_percent}{
Numeric. Oxygen saturation percentage on room air. (< 90\% adds 6 points).
}
}
\value{
A list containing:
\item{STUMBL_Score}{The calculated total score (Range 0-24).}
\item{Risk_Category}{Risk stratification (Low <= 10, High >= 11).}
\item{Management_Guidance}{Recommendations for discharge or admission based on the score.}
}
\references{
Battle C, Hutchings H, Lovett S, et al. Predicting outcomes after blunt chest wall trauma: development and external validation of a new prognostic model. Crit Care. 2014;18(3):R98. doi:10.1186/cc13873
}
\examples{

# Example 1: High Risk
# 70yo (+5), 3 ribs (+4), COPD (+5), SpO2 95%
# Score = 14
stumbl_battle_score(70, 3, 1, 0, 95)

# Example 2: Low Risk
# 40yo, 2 ribs, No hx, SpO2 98%
# Score = 0
stumbl_battle_score(40, 2, 0, 0, 98)
}
