\name{visual_acuity_converter}
\alias{visual_acuity_converter}
\title{
Visual Acuity Testing Converter (Snellen)
}
\description{
Converts standard Snellen visual acuity (measured at 20 feet) into other common clinical notations, including Metric (6 meters), Decimal, and LogMAR. This utility assists in standardizing visual acuity records across different medical systems and research protocols.
}
\usage{
visual_acuity_converter(snellen_denominator)
}
\arguments{
  \item{snellen_denominator}{
Numeric. The denominator of the visual acuity fraction when the numerator is 20 (e.g., entered as 20 for 20/20 vision, 40 for 20/40 vision). Must be a positive number.
}
}
\details{
The conversions are based on the following relationships:
\itemize{
  \item Decimal = 20 / Snellen Denominator
  \item Metric Denominator = Snellen Denominator * 0.3
  \item LogMAR = -log10(Decimal Acuity)
}
}
\value{
A list containing the converted values:
\item{Snellen_Imperial}{The standard US notation (e.g., "20/20").}
\item{Snellen_Metric}{The metric notation used in many other countries (e.g., "6/6").}
\item{Decimal}{The decimal equivalent (e.g., 1.0 for 20/20, 0.5 for 20/40).}
\item{LogMAR}{The Logarithm of the Minimum Angle of Resolution.}
}
\references{
Holladay JT. Visual acuity measurements. J Cataract Refract Surg. 2004;30(2):287-290. doi:10.1016/j.jcrs.2004.01.014
}
\examples{

# Example 1: 20/40 vision
visual_acuity_converter(40)

# Example 2: 20/200 vision (Legal Blindness boundary in US)
visual_acuity_converter(200)
}
