\name{wifi_classification}
\alias{wifi_classification}
\title{
Wound, Ischemia, and foot Infection (WIfI) Classification System
}
\description{
Calculates the WIfI classification stage to predict the 1-year risk of major amputation and the potential benefit of revascularization in patients with threatened lower limbs (chronic limb-threatening ischemia). The system integrates three key factors: Wound extent, Ischemia severity, and foot Infection severity.
}
\usage{
wifi_classification(wound_grade, ischemia_grade, infection_grade)
}
\arguments{
  \item{wound_grade}{
Numeric (0-3).
0: No ulcer/gangrene.
1: Small ulcer, no gangrene.
2: Deep ulcer or gangrene limited to digits.
3: Extensive ulcer or gangrene involving forefoot/midfoot.
}
  \item{ischemia_grade}{
Numeric (0-3). Based on ABI, Ankle Pressure (AP), or Toe Pressure (TP).
0: ABI >= 0.80, TP >= 60.
1: ABI 0.6-0.79, TP 40-59.
2: ABI 0.4-0.59, TP 30-39.
3: ABI <= 0.39, TP < 30.
}
  \item{infection_grade}{
Numeric (0-3). Based on IDSA/IWGDF criteria.
0: No infection.
1: Mild (local < 2cm cellulitis).
2: Moderate (> 2cm cellulitis or deep structures).
3: Severe (SIRS/Sepsis).
}
}
\value{
A list containing:
\item{WIfI_Stage}{The calculated clinical stage (1-4).}
\item{Amputation_Risk_1_Year}{Estimated risk of major amputation at 1 year (Very Low, Low, Moderate, High).}
\item{Revascularization_Benefit}{Estimated benefit of revascularization.}
}
\references{
Mills JL Sr, Conte MS, Armstrong DG, et al. The Society for Vascular Surgery Lower Extremity Threatened Limb Classification System: risk stratification based on wound, ischemia, and foot infection (WIfI). J Vasc Surg. 2014;59(1):220-34.e1-2. doi:10.1016/j.jvs.2013.08.003
}
\examples{

# Example 1: High Risk
# Extensive gangrene (3), Severe Ischemia (3), Moderate Infection (2)
wifi_classification(3, 3, 2)

# Example 2: Low Risk
# Small ulcer (1), Mild Ischemia (1), No Infection (0)
wifi_classification(1, 1, 0)
}
