% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_transfer.R
\name{cloud_s3_download}
\alias{cloud_s3_download}
\title{Download a file from S3 to the local project folder}
\usage{
cloud_s3_download(file, root = NULL)
}
\arguments{
\item{file}{Path to a file relative to project folder root. Can contain only
letters, digits, '-', '_', '.', spaces and '/' symbols.}

\item{root}{S3 path of the project root. This serves as the reference point
for all relative paths. When left as \code{NULL}, the root is automatically
derived from the \code{cloudfs.s3} field of the project's DESCRIPTION file.}
}
\value{
Invisibly returns \code{NULL} after successfully downloading the file.
}
\description{
Retrieves a file from the project's S3 root folder and saves it
to the local project folder, maintaining the original folder structure.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# downloads toy_data/demo.csv from project's S3 folder (provided it exists)
# and saves it to local 'toy_data' folder
cloud_s3_download("toy_data/demo.csv")

# clean up
unlink("toy_data", recursive = TRUE)
\dontshow{\}) # examplesIf}
}
