% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cb_set_columns.R
\name{cb_set_columns}
\alias{cb_set_columns}
\title{Set the columns in a cohort}
\usage{
cb_set_columns(cohort, column_ids, keep_columns = TRUE)
}
\arguments{
\item{cohort}{A cohort object. (Required)
See constructor function \code{\link{cb_create_cohort}} or \code{\link{cb_load_cohort}}}

\item{column_ids}{Vector of phenotype IDs to be added as columns in the participant table.}

\item{keep_columns}{If True, pre-existing columns are retained and newly supplied columns are added.
Otherwise, pre-exisitng columns are overwritten. (Default: TRUE)}
}
\value{
The updated cohort object.
}
\description{
Updates a cohort by applying a new query.
}
\examples{
\dontrun{
my_cohort <- cb_load_cohort(cohort_id = "612f37a57673ed0ddeaf1333", cb_version = "v2")

my_cohort <- cb_set_columns(my_cohort, c(1, 99, 38), keep_columns = F)
}

}
