% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nregtestrel.R
\name{nregtestrel}
\alias{nregtestrel}
\title{Nonregression-based Measures of Deviation.}
\usage{
nregtestrel(x, y, w, w_avg, mev, Q)
}
\arguments{
\item{x}{price vector (1 x n).}

\item{y}{value vector (1 x n).}

\item{w}{nominal wage rate vector (1 x n).}

\item{w_avg}{average nominal wage rate (scalar)}

\item{mev}{monetary expression of value using gross output (scalar)}

\item{Q}{gross output vector (n x 1).}
}
\value{
A list with the following elements:
\item{rmse}{Root mean squared error}
\item{mad}{Mean absolute distance}
\item{mawd}{Mean absolute weighted distance}
\item{cdm}{Classical distance measure}
\item{angle}{Angle between the two vectors (in degrees)}
\item{distangle}{Distance computed using the angle}
\item{lrelpplv}{Length of the relative price of production (or labor value) vector}
}
\description{
This function computes various non-regression based measures of deviation between the vector of all possible relative labor values and the vector of all possible relative prices of production.
}
\examples{


# Input-output matrix
A <- matrix(
data = c(0.265,0.968,0.00681,0.0121,0.391,0.0169,0.0408,0.808,0.165),
nrow=3, ncol=3, byrow = TRUE
)
# Direct labor input vector (complex)
l <- matrix(
data = c(0.193, 3.562, 0.616),
nrow=1
)
# Real wage bundle
b <- matrix(
data = c(0.0109, 0.0275, 0.296),
ncol=1
)
# Gross output vector
Q <- matrix(
data = c(26530, 18168, 73840),
ncol=1
)
# Direct labor input vector (simple)
l_simple <- l
# Market price vector
m <- matrix(data = c(4, 60, 7),nrow=1)
# Uniform nominal wage rate
wavg <- m\%*\%b
# Vector of nominal wage rates
w <- matrix(data=rep(wavg,3),nrow=1)
# Value of labor power
v <- 2/3
# Compute prices of production using NI
ni1 <- ppnewint1(A = A,l = l,w = wavg[1,1],v=v,Q = Q,l_simple = l)
# Nonregression-based measures of deviation
nregtestrel(x=ni1$ppabs,y=ni1$lvalues,w=w,w_avg=wavg[1,1],mev=ni1$mevg,Q=Q)
}
\references{
Basu, Deepankar and Moraitis, Athanasios, "Alternative Approaches to Labor Values andPrices of Production: Theory and Evidence" (2023). Economics Department Working Paper Series. 347. URL: https://scholarworks.umass.edu/econ_workingpaper/347/
}
