% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{TransitionCan-class}
\alias{TransitionCan-class}
\alias{TransitionCan}
\title{External Transition Candidates}
\description{
Class containing candidates that adopted external transition from first clustering \eqn{\xi_1},
and emerged as new clusters at second clustering \eqn{\xi_2}.
}
\section{Slots}{

\describe{
\item{\code{SurvivalCanx}}{Vector of integers comprising Candidates that Survive from first clustering \eqn{\xi_1}.}

\item{\code{SurvivalCany}}{Vector of integers comprising Candidates that Survive to second clustering \eqn{\xi_2}.}

\item{\code{SplitCanx}}{Vector of integers comprising Candidates that Sliced into Various daughter Clusters from
first clustering \eqn{\xi_1}.}

\item{\code{SplitCany}}{List of integer vectors comprising Candidates that emerged as daughter clusters in second clustering \eqn{\xi_2}
because of Split from first clustering \eqn{\xi_1}.}

\item{\code{MergeCanx}}{List of integer vectors comprising Candidates from first clustering \eqn{\xi_1} that are merged.
Each slot of list indicates the clusters that merge together from first clustering.}

\item{\code{MergeCany}}{Vector of integers comprising Candidates that emerged in second clustering \eqn{\xi_2} because
of merging various clusters from first clustering \eqn{\xi_1}.}

\item{\code{EmergCan}}{Newley emerged candidates which are not a result of any external transition from first clustering \eqn{\xi_1}.}

\item{\code{Cluster_Tracey}}{Vector of Cluster Trace from second clustering \eqn{\xi_2}.}
}}

