% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{linrclus}
\alias{linrclus}
\title{Linear regression via coordinate descent with covariate clustering}
\usage{
linrclus(Y, X, k, coefs, clus, clusmns, nC = 1, x = FALSE)
}
\arguments{
\item{Y}{vector of outcome variable}

\item{X}{matrix of covariates. Should not include 1's for the intercept}

\item{k}{number of clusters}

\item{coefs}{vector of coefficients as starting values. Should not include the intercept.}

\item{clus}{vector of covariate cluster assignments as starting values}

\item{clusmns}{vector k cluster parameter centers}

\item{nC}{first nC-1 covariates in X not to cluster. Must be at least 1 for the intercept}

\item{x}{a logical for returning the design matrix}
}
\value{
clus cluster assignments

coefs vector of coefficients as starting values

clusmns vector of cluster means
}
\description{
Covariate assignment to k clusters using the coordinate descent algorithm. This
function is a wrapper for the \code{C} function \code{linreg_coord_clus}
}
\examples{
set.seed(14) #Generate data
N = 1000; (bets = rep(-2:2,4)); p = length(bets); X = matrix(rnorm(N*p),N,p)
Y = cbind(1,X)\%*\%matrix(c(0.5,bets),ncol = 1)
begin_v<- rep(NA,p)
for (j in 1:p) {
 begin_v[j] = stats::coef(lm(Y~X[,j]))[2]
}
set.seed(12); klus_obj<- kmeans(begin_v,centers = 5)
linrclus(Y,X,k=5,coefs=c(0,begin_v),clus=klus_obj$cluster,clusmns=klus_obj$centers)
}
