% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_kproto.R
\name{stability_kproto}
\alias{stability_kproto}
\title{Determination the stability of k Prototypes Clustering}
\usage{
stability_kproto(
  object,
  method = c("rand", "jaccard", "luxburg", "fowlkesmallows"),
  B = 100,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class \code{kproto} resulting from a call with \code{kproto(..., keep.data=TRUE)}}

\item{method}{character specifying the stability, either one or more of \code{luxburg}, \code{fowlkesmallows}, \code{rand} or/and \code{jaccard}.}

\item{B}{numeric, number of bootstrap samples}

\item{verbose}{Logical whether information about the bootstrap procedure should be given.}

\item{...}{Further arguments passed to \code{\link[clustMixType]{kproto}}, like:
\itemize{
  \item \code{nstart}: If > 1 repetitive computations of \code{kproto} with random initial prototypes are computed.
  \item \code{lambda}: Factor to trade off between Euclidean distance of numeric variables and simple matching coefficient between categorical variables.
}}
}
\value{
The output contains the stability for a given k-Prototype clustering in a list with two elements:

\item{kp_stab}{stability values for the given clustering}

\item{kp_bts_stab}{stability values for each bootstrap samples}
}
\description{
Calculating the stability for a k-Prototypes clustering with k clusters or computing the stability-based optimal number of clusters for k-Prototype clustering. Possible stability indices are: \code{Jaccard}, \code{Rand}, \code{Fowlkes \& Mallows} and \code{Luxburg}.
}
\examples{
\dontrun{
# generate toy data with factors and numerics
n   <- 10
prb <- 0.99
muk <- 2.5 

x1 <- sample(c("A","B"), 2*n, replace = TRUE, prob = c(prb, 1-prb))
x1 <- c(x1, sample(c("A","B"), 2*n, replace = TRUE, prob = c(1-prb, prb)))
x1 <- as.factor(x1)
x2 <- sample(c("A","B"), 2*n, replace = TRUE, prob = c(prb, 1-prb))
x2 <- c(x2, sample(c("A","B"), 2*n, replace = TRUE, prob = c(1-prb, prb)))
x2 <- as.factor(x2)
x3 <- c(rnorm(n, mean = -muk), rnorm(n, mean = muk), rnorm(n, mean = -muk), rnorm(n, mean = muk))
x4 <- c(rnorm(n, mean = -muk), rnorm(n, mean = muk), rnorm(n, mean = -muk), rnorm(n, mean = muk))
x <- data.frame(x1,x2,x3,x4)

#' # apply k-prototypes
kpres <- kproto(x, 4, keep.data = TRUE)

# calculate cluster stability
stab <- stability_kproto(method = c("luxburg","fowlkesmallows"), object = kpres)

}

}
\references{
\itemize{
    \item Aschenbruck, R., Szepannek, G., Wilhelm, A.F.X (2023): 
    Stability of mixed-type cluster partitions for determination of the number of clusters. 
    \emph{Submitted}.
    
    \item von Luxburg, U. (2010): 
     Clustering stability: an overview. 
    \emph{Foundations and Trends in Machine Learning, Vol 2, Issue 3}.
    \doi{10.1561/2200000008}.
    
    \item Ben-Hur, A., Elisseeff, A., Guyon, I. (2002): 
    A stability based method for discovering structure in clustered data. 
    \emph{Pacific Symposium on Biocomputing}.
    \doi{10/bhfxmf}.
  }
}
\author{
Rabea Aschenbruck
}
