% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plot_clusters}
\alias{plot_clusters}
\title{plot_clusters}
\usage{
plot_clusters(
  cluster_results,
  node_colours = "#fdae61",
  scale_entropy = FALSE,
  directed = TRUE
)
}
\arguments{
\item{cluster_results}{Cluster results}

\item{node_colours}{node colours}

\item{scale_entropy}{if true, entropy measure will be used to determine size of the nodes}

\item{directed}{TRUE if nodes should be directed}
}
\value{
A summary plot of all cluster networks of class c("gg", "ggplot", "ggarrange").
}
\description{
Plot clusters
}
\examples{
\donttest{
# Simulate data
sampled_data <- sampleData(n_vars = 15, n_bg = 0)$sampled_data
# learn clusters
cluster_results <- get_clusters(sampled_data)
# Load additional pacakges to visualize the networks
library(ggplot2)
library(ggraph)
library(igraph)
library(ggpubr)
# Visualize networks
plot_clusters(cluster_results)
}
}
