% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcnb.R
\name{pcnb}
\alias{pcnb}
\title{CDF of Conditional Negative Binomial}
\usage{
pcnb(x, D, r1, r2, lambda)
}
\arguments{
\item{x}{a nonempty vector of real numbers.}

\item{D}{a positive integer.}

\item{r1}{a positive value.}

\item{r2}{a positive value.}

\item{lambda}{a positive value.}
}
\value{
A vector providing values of Pr(X <= x | X + Y = D) for each element in x.
}
\description{
Cumulative distribution function of the conditional distribution of X given X + Y = D,
where X ~ NB(r1, p1) and Y ~ NB(r2, p2) are drawn from two negative binomials,
independent of each other,
and assuming p1/p2 = lambda.
}
\details{
Need to specify full list of arguments, as default values have not been set.
}
\examples{
pcnb(980, 2000, 120, 90, 0.994)
pcnb(0:7, 7, 2, 0.4, 0.6)

}
\seealso{
\code{\link{dcnb}, \link{qcnb}, \link{rcnb}.}
}
\author{
Xiaotian Zhu, \email{xiaotian.zhu.psualum@gmail.com}
}
