% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcnb.R
\name{rcnb}
\alias{rcnb}
\title{Random Number Generation from Conditional Negative Binomial}
\usage{
rcnb(n, D, r1, r2, lambda)
}
\arguments{
\item{n}{a positive integer.}

\item{D}{a positive integer.}

\item{r1}{a positive value.}

\item{r2}{a positive value.}

\item{lambda}{a positive value.}
}
\value{
n iid draws from X|X+Y=D.
}
\description{
Random number generation from the conditional distribution of X given X + Y = D,
where X ~ NB(r1, p1) and Y ~ NB(r2, p2) are drawn from two negative binomials,
independent of each other,
and assuming p1/p2 = lambda.
}
\details{
Need to specify full list of arguments, as default values have not been set.
}
\examples{
x <- rcnb(1e3, 7, 2, 0.4, 0.6)
hist(x)

}
\seealso{
\code{\link{dcnb}, \link{pcnb}, \link{qcnb}.}
}
\author{
Xiaotian Zhu, \email{xiaotian.zhu.psualum@gmail.com}
}
