
# Generation of Code Names for Organizations, People, Projects, and Whatever Else

[![](https://www.r-pkg.org/badges/version/codename?color=green)](https://cran.r-project.org/package=codename)
[![](http://cranlogs.r-pkg.org/badges/grand-total/codename?color=green)](https://cran.r-project.org/package=codename)
[![](http://cranlogs.r-pkg.org/badges/last-month/codename?color=green)](https://cran.r-project.org/package=codename)
[![](http://cranlogs.r-pkg.org/badges/last-week/codename?color=green)](https://cran.r-project.org/package=codename)

`{codename}` allows for users to create short, pithy code names for
their organizations, their work projects, themselves, other people, or
whatever else. The core of this package is the eponymous `codename()`
function, which allows the user to create various types of code names.
The code names returned from this function, by in large, are a two-word
character vector of an attribute and an object. Right now, options
include “any” (which is default and incorporates a battery of adjectives
and nouns), “gods” (in which the object is the name of a deity or saint
from some religion), “ubuntu” (in which the code name is alliterative
but the object is always an animal), ‘nicka’ (in which code names are
partly derived from conventions spelled out by the old U.S. NICKA
system) and “wu-tang” (in which the code name is derived from the
classic Wu-Tang Name Generator). `codename()` also features the ability
to use reproducible seeds, including character seeds, for maximum
transparency and reproducibility.

# Installation

You can install this on CRAN.

``` r
install.packages("codename")
```

You can also install the development version of this package through the
`{devtools}` package.

``` r
devtools::install_github("svmiller/codename")
```

# Usage

There isn’t much to belabor here and usage should be self-explanatory.
Here is some sample output.

``` r
library(codename)

# Generate console message about package version.
# Successive updates may break the expected output of a reproducible seed.
# This just adds some layer of transparency/clarity.
codename_message()
#> code name generated by {codename} v.0.4.9. R version 4.1.2 (2021-11-01).

# defaults to any
codename()
#> [1] "burnt red helium"
codename()
#> [1] "unrealistic half"
codename()
#> [1] "straight digestive"
codename()
#> [1] "limited coonskin"

codename(type = "gods")
#> [1] "jaunty yahweh"
codename(type = "gods")
#> [1] "these auseklis"
codename(type = "gods")
#> [1] "honored chernobog"
codename(type = "gods")
#> [1] "dark blue grey dagon"

codename(type = "nicka")
#> [1] "ill myth"
codename(type = "nicka")
#> [1] "twin worship"
codename(type = "nicka")
#> [1] "frivolous barn"
codename(type = "nicka")
#> [1] "definite metronome"

codename(type = "ubuntu")
#> [1] "reflecting rattlesnake"
codename(type = "ubuntu")
#> [1] "wintergreen weasel"
codename(type = "ubuntu")
#> [1] "virtuous vole"
codename(type = "ubuntu")
#> [1] "hoarse hippopotamus"

codename(type = "wu-tang")
#> [1] "Mighty Worlock"
codename(type = "wu-tang")
#> [1] "Mighty Beggar"
codename(type = "wu-tang")
#> [1] "Violent Commander"
codename(type = "wu-tang")
#> [1] "Vulgar Lover"

variety_pack(seed = "A Reproducible Character Seed")
#> [1] "afraid patriarch"
#> [1] "meaty ausrine"
#> [1] "xiphoid xenarthra"
#> [1] "banana barnacle"
#> [1] "Scratchin’ Commander"
variety_pack(seed = 8675309)
#> [1] "yellow orange twist"
#> [1] "scholarly wakan tanka"
#> [1] "wavy wear"
#> [1] "moss mandrill"
#> [1] "Thunderous Wizard"
```

# Hall of Fame Entries

This is an incomplete and running list of some of my favorite returns
from this function. Because most of the sample output on the README is a
one-off return, these are prone to disappear every time the README is
updated. No matter, I want to preserve some of these, for posterity.

- electric lime agenda
- second-hand shovel
- reckless azimuth
- x-pert anesthesiology
- sunny sunroom
- improbable boris
- criminal outlaw
- gregarious denominator
- lawn green insurgence
- corrupt chickadee
- realistic democrat
- creamy escalator
- recent prior
- sapphire guacamole
- deserted samurai
- subtle girlfriend
- critical father
- short-term opposition
- favorite weakness
- lavender pawnshop
- pungent pigeon
- gifted gerbil
- guilty gorilla
- sniveling snail
- foolish soma
- baby poop buddha
- sizzling sawfish

# `{codename}` in the Wild

Here’s a running list of projects that make use of `{codename}`. If you
would like your project included, please [raise an
issue](https://github.com/svmiller/codename/issues) on the project’s
Github.

- [**corrupt
  caterpillar**](https://github.com/andrewheiss/corrupt-caterpillar)
