% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salmon.R
\docType{data}
\name{salmon}
\alias{salmon}
\title{The St. Marguerite River Altantic Salmon Parr Transect}
\format{
A 76 rows by  5 columns \code{\link{data.frame}}.
}
\source{
Daniel Boisclair, Département de sciences biologiques, Université de
Montréal, Montréal, Québec, Canada.
}
\usage{
data(salmon)
}
\description{
Juvenile Atlantic salmon (parr) density in a 1520m transect of the St.
Marguerite River, Québec, Canada.
}
\details{
Contains (1) the 76 sampling site positions along a 1520 m river
segment beginning at a location called `Bardsville` (Lat: 48°23'01.59'' N ;
Long: 70°12'10.05'' W), (2) the number of parr (young salmon, ages I+ and
II+) observed at the sampling sites, (3) the mean water depths (m), (4) the
mean current velocity (m/s), and (5) the mean substrate size (mm). Sampling
took place on July 7, 2002, in the 76 sites, each 20 m long. The `Bardsville`
river segment is located in the upper portion of Sainte-Marguerite River,
Quebec, Canada.
}
\examples{
data(salmon)
summary(salmon)

}
\references{
Guénard, G., Legendre, P., Boisclair, D., and Bilodeau, M. 2010. Multiscale
codependence analysis: an integrated approach to analyse relationships across
scales. Ecology 91: 2952-2964
}
\seealso{
Bouchard, J. and Boisclair, D. 2008. The relative importance of local,
lateral, and longitudinal variables on the development of habitat quality
models for a river. Can. J. Fish. Aquat. Sci. 65: 61-73
}
\keyword{salmon}
