% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_stroke.r
\name{draw_stroke}
\alias{draw_stroke}
\title{Visualize Stroke Region and Center of Gravity (COG)}
\usage{
draw_stroke(lst, show_cog = TRUE, plot_image = TRUE)
}
\arguments{
\item{lst}{A list returned by \code{\link{cog_stroke}}, containing
stroke pixel data and computed statistics.}

\item{show_cog}{Logical. If \code{TRUE} (default), draws horizontal and vertical
red lines through the COG to visualize its position.}

\item{plot_image}{Logical. If \code{TRUE} (default), plots the image. If \code{FALSE},
returns the image object without plotting.}
}
\value{
An object of class \code{cimg} representing the stroke image (with or without
COG lines), suitable for plotting or further manipulation.
}
\description{
Visualizes the stroke region of a character-like binary image using the result
from \code{cog_stroke()}. Optionally overlays crosshair lines at the computed
center of gravity (COG) position.
}
\examples{
\dontshow{if ((identical(Sys.getenv("IN_PKGDOWN"), "true") || interactive())) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(img_A) # load example image from the package
result <- cog_stroke(img_A)
draw_stroke(result, show_cog = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{cog_stroke}}
}
