% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{ProjectCMap}
\alias{ProjectCMap}
\title{Import a Qualitatve Data Analysis project}
\usage{
ProjectCMap(main_path, project_name, coder = "qcoder", sep = ">")
}
\arguments{
\item{main_path}{The main to your QDA project. It must ended with '/'}

\item{project_name}{The name of your project (as defined in 'qcoder', the name of the subfolder in your main_path). This name is also used in some filenames in the data_frame subsubfolders.}

\item{coder}{A character string indicating the coding tool used for coding the QDA. The only tool supported now is 'qcoder'. Earlier version of cogmapr worked with "RQDA" project (no more maintened).}

\item{sep}{(==Depreciated, with RQDA project==) A character string (often a single character) that is used in RQDA in order to express the relationships between two variables. Default is "_" if codes used in RQDA are of the form : "x_y" (\emph{i.e.} relationship from x to y), but it is possible to use ">", "->", "-->" or even "--->"}
}
\value{
A list
}
\description{
This function import and format the data from a coding tool in a Qualitatve Data Analysis.
}
\details{
This function import and format the data from a coding tool in a Qualitatve Data Analysis (QDA).
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)
}
