% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cointReg}
\alias{plot.cointReg}
\title{Plot Method for Cointegration Models (Modified OLS).}
\usage{
\method{plot}{cointReg}(x, type, main, xlab, ylab, axes = TRUE, ...)
}
\arguments{
\item{x}{[\code{cointReg}]\cr
Object of class \code{"cointReg"}, i.e. the result of
\code{\link{cointRegFM}}, \code{\link{cointRegD}},
or \code{\link{cointRegIM}}.}

\item{type}{[\code{character}]\cr
Plot type (from \code{\link{plot}}). Default is \code{"l"}.}

\item{main, xlab, ylab}{[\code{character}]\cr
Title and axis titles (from \code{\link{plot}}). Default values will be
generated from the contents of \code{x}.}

\item{axes}{[\code{logical}]\cr
Whether to add axes (from \code{\link{plot}}) to the plot.}

\item{...}{[\code{any}]\cr
Further arguments passed to \code{\link{plot}}.}
}
\description{
Plotting objects of class \code{"cointReg"}. Currently, only the residuals
will be plotted.
}
\examples{
set.seed(42)
x = data.frame(x1 = cumsum(rnorm(200)), x2 = cumsum(rnorm(200)))
eps1 = rnorm(200, sd = 2)
y = x$x1 - x$x2 + 10 + eps1
deter = cbind(level = rep(1, 200))
test = cointRegFM(x = x, y = y, deter = deter)
plot(test)

}
\seealso{
Other cointReg: \code{\link{cointRegD}},
  \code{\link{cointRegFM}}, \code{\link{cointRegIM}},
  \code{\link{cointReg}}, \code{\link{print.cointReg}}
}

