# [Collatz](https://github.com/Skenvy/Collatz): [R](https://github.com/Skenvy/Collatz/tree/main/R) 🏴‍☠️🔵🦜
Functions related to [the Collatz/Syracuse/3N+1 problem](https://en.wikipedia.org/wiki/Collatz_conjecture), implemented in [R](https://www.r-project.org/).

## Getting Started
[To install the latest from github, with devtools](https://github.com/Skenvy/Collatz/tree/main/R);
```sh
Rscript -e 'devtools::install_github("Skenvy/Collatz", subdir="R")'
```
[To install a specific GitHub release's tarball](https://github.com/Skenvy/Collatz/releases) (all `R-v*` tagged releases include a `collatz_*.tar.gz`, simply copy the below and change the example version from `0.1.0` to whichever version you want);
```sh
VER=1.0.0 && curl -L https://github.com/Skenvy/Collatz/releases/download/R-v${VER}/collatz_${VER}.tar.gz > collatz_${VER}.tar.gz && Rscript -e "install.packages('collatz_${VER}.tar.gz', repos=NULL, type='source')"
```
[To install the latest from CRAN](https://cran.r-project.org/package=collatz) (_relevancy pending the submission to CRAN and its ongoing stability_);
```sh
Rscript -e 'install.packages("collatz")'
```

## Usage
Provides the basic functionality to interact with the Collatz conjecture.
The parameterisation uses the same `(P,a,b)` notation as Conway's generalisations.
Besides the function and reverse function, there is also functionality to retrieve the hailstone sequence, the "stopping time"/"total stopping time", or tree-graph. 
The only restriction placed on parameters is that both `P` and `a` can't be `0`.

## [Roxygen2+Pkgdown generated docs](https://skenvy.github.io/Collatz/R/)

## [Covr+DT generated Coverage](https://skenvy.github.io/Collatz/R/covr/Collatz-report.html)

## [Rd2pdf+TinyTex Generated PDF](https://skenvy.github.io/Collatz/R/pdf/)

## Developing

### The first time setup
On a debian system, this _should_ be most of the required setup.
```sh
git clone https://github.com/Skenvy/Collatz.git && cd Collatz/R && sudo make setup_debian && make setup && make setup_libraries
```

### Iterative development
* `make docs_local` to start a [local server](http://localhost:4321) to browse the docs generated by roxygen2, pkgdown, covr, Rd2pdf and TinyTex, served by servr.
* `make full_test` will verify the integrity of the package after passing the tests, as passing the tests is a lower threshold than package structure.
