% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{colleyRstats_setup}
\alias{colleyRstats_setup}
\title{Configure Global R Environment for colleyRstats}
\usage{
colleyRstats_setup(
  set_options = TRUE,
  set_theme = TRUE,
  set_conflicts = TRUE,
  print_citation = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{set_options}{Logical. If \code{TRUE}, prints a notice that global
options are no longer changed automatically. Default is \code{TRUE}.}

\item{set_theme}{Logical. If \code{TRUE}, sets the default \code{ggplot2} theme
to \code{see::theme_lucid} with custom modifications. Default is \code{TRUE}.}

\item{set_conflicts}{Logical. If \code{TRUE}, sets \code{conflicted} preferences
to favor \code{dplyr} and other tidyverse packages. Default is \code{TRUE}.}

\item{print_citation}{Logical. If \code{TRUE}, prints the citation information
for this package. Default is \code{TRUE}.}

\item{verbose}{Logical. If \code{TRUE}, emit informational messages.
Default is \code{TRUE}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Sets ggplot2 themes and conflict preferences to match the
standards used in the colleyRstats workflow.
}
\examples{
# Runs everywhere, no extra packages, no session side effects
colleyRstats::colleyRstats_setup(
  set_options = FALSE,
  set_theme = FALSE,
  set_conflicts = FALSE,
  print_citation = FALSE,
  verbose = FALSE
)

\donttest{
# Full setup (requires suggested packages; changes session defaults)
if (requireNamespace("ggplot2", quietly = TRUE) &&
    requireNamespace("see", quietly = TRUE)) {
  local({
    old_theme <- ggplot2::theme_get()
    on.exit(ggplot2::theme_set(old_theme), add = TRUE)

    colleyRstats::colleyRstats_setup(
      set_options = FALSE,
      set_conflicts = FALSE,   # avoid persisting conflict prefs in checks
      print_citation = FALSE,
      verbose = TRUE
    )

    ggplot2::ggplot(mtcars, ggplot2::aes(mpg, wt)) +
      ggplot2::geom_point()
  })
}
}
}
