% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{multi_rnorm}
\alias{multi_rnorm}
\title{Generate Correlated Normal Random Numbers}
\usage{
multi_rnorm(n, mean, sd)
}
\arguments{
\item{n}{The number of samples desired for each variable.}

\item{mean}{A vector giving the mean of each variable.}

\item{sd}{A valid covariance matrix.}
}
\value{
A matrix with n rows and as many columns as mean values.
}
\description{
Generate random numbers from a multivariate normal distribution.
It can be used to create correlated random numbers.
}
\examples{
mus <- c(0, 3, 5)
sigmas <- matrix(c(1, 0.265, 2.19, 0.265, 0.25, 0.66, 2.19, 0.66, 9), ncol = 3)
mat <- multi_rnorm(100, mus, sigmas)
var(mat)
}
