% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorize.R
\name{colorize}
\alias{colorize}
\alias{colorize_bg}
\title{Render text in color for Markdown / Quarto documents}
\usage{
colorize(text, color, format = NULL)

colorize_bg(text, color, format = NULL)
}
\arguments{
\item{text}{Text to display, a character string}

\item{color}{Color to use, a valid color designation; if missing, use \code{text} as the color}

\item{format}{character specification of the output format. Currently supported formats are:
\code{"latex"} (default if \code{\link[knitr]{is_latex_output}}),
\code{"html"} (default if \code{\link[knitr]{is_html_output}},
and \code{"text"} (otherwise) are supported where the latter just contains
the input \code{text} without any color formatting.}
}
\value{
A character string with the input text along with markup for color encoding.
}
\description{
The \code{colorize()} function renders text in color for Markdown / Quarto documents. For documents to be rendered in HTML,
it uses a CSS \verb{<span>}; for documents to be converted to LaTeX and rendered as PDF, it
uses \verb{\\textcolor\{\}\{\}} from the \href{https://ctan.org/pkg/xcolor}{\code{xcolor}} package.
}
\details{
A companion function, \code{colorize_bg()} does the same, but uses the specified color for the background.

The names of colors
Note that a color name not defined in the \href{https://ctan.org/pkg/xcolor}{\code{xcolor}} package will trigger a LaTeX error.
e.g., \code{darkgreen} is not defined but you can use:
\verb{\\definecolor\{darkgreen\}\{RGB\}\{1,50,32\}} in a document to be rendered to PDF.

For inline text, in running text, you can use:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ `r colorize("Gentoo", "orange")` and  `r colorize("Adelie", "purple")` are Penguins.
 The `r colorize("red")` points and the `r colorize("blue")` points are nice
}\if{html}{\out{</div>}}

In a chunk, you can also define variables with the names of colors, for ease of use:

\preformatted{
 red <- colorize('red')
 pink <- colorize("pink")
 blue <- colorize('blue')
 green <- colorize("green")
 yellow <- colorize("yellow")
 }

Then, these can be used directly in strings, interpolated by \code{glue::glue()}. This is particularly useful in figure captions.
}
\examples{
# show what the generated text looks like when encoded for either HTML or LaTeX
colorize("red", format = "html") |> cat()
colorize("red", format = "latex") |> cat()

colorize_bg("blue", format = "html") |> cat()
colorize_bg("blue", format = "latex") |> cat()

\donttest{
 red <- colorize('red')
 blue <- colorize('blue')
 green <- colorize("green")
 glue::glue("There are {red} points, {blue} points and {green} points")
 }

}
\author{
Michael Friendly
}
