% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eplcolors.r
\name{epl.colors}
\alias{epl.colors}
\title{EPL colors}
\usage{
epl.colors(set = c("arsenal", "bournemouth", "burnley", "chelsea",
  "crystal_palace", "everton", "hull", "leicester", "liverpool", "man_city",
  "man_united", "middlesbrough", "southampton", "stoke_city", "sunderland",
  "swansea_city", "tottenham", "watford", "west_bromich_albion", "west_ham"))
}
\arguments{
\item{set}{Character string denoting an EPL team's color palette.}
}
\value{
Vector of character strings from the selected EPL team's color palette.
}
\description{
Function returns a vector of character strings from a selected EPL team's color palette. The team options are c("arsenal", "bournemouth", "burnley", "chelsea", "crystal_palace", "everton", "hull", "leicester", "liverpool", "man_city", "man_united", "middlesbrough", "southampton", "stoke_city", "sunderland", "swansea_city", "tottenham", "watford", "west_bromich_albion", "west_ham").
}
\examples{
\dontrun{
# Manchester United colors
(pal = epl.colors("man_united"))
pie(rep(1, length(pal)), labels = sprintf("\%d (\%s)", seq_along(pal), pal), col = pal)

# Tottenham colors
(pal = epl.colors("tottenham"))
pie(rep(1, length(pal)), labels = sprintf("\%d (\%s)", seq_along(pal), pal), col = pal)
}
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}
