% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_shortIronCondor.R
\name{shortIronCondor}
\alias{shortIronCondor}
\title{Calculates per share Profit and Loss (PnL) at expiration for Short Iron Condor Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
shortIronCondor(
  ST,
  X1L,
  X2,
  X3,
  X4H,
  P1L,
  P2,
  C3,
  C4H,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price for one OTM shorted Put.}

\item{X2}{Strike Price or eXercise price for one bought Put.}

\item{X3}{Strike Price or eXercise price for one bought Call.}

\item{X4H}{Higher Strike Price or eXercise price for one OTM shorted Call.}

\item{P1L}{Put Premium or Put Price received for the first OTM shorted Put.}

\item{P2}{Put Premium or Put Price paid for the bought Put.}

\item{C3}{Put Premium or Put Price paid for the bought Call.}

\item{C4H}{Call Premium or Put Price received for the one OTM shorted Call.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This volatility strategy is a combination of a bear put spread and a bull call spread and consists of a short position in an OTM put option (out of the money put : put Strike price is lower than spot price X1L )  with a strike price X1L, a long position in put option with higher Strike X2 price and a long position  OTM (out of the money)  call option with a strike price X3, and a short position in call option  with a higher strike price X4H. The strikes are equidistant: X2 minus X1L equals to X4H minus X3 . This is a net debit trade. The trader or investor has an outlook that is  neutral (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Short Iron Condor Option Strategy and draw its graph in the Plots tab.
}
\examples{
shortIronCondor(405,400,410,420,430,8,11,13,9,hl=0.95,hu=1.1)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865 \cr
R Graphics Cookbook. (n.d.). Coloring Negative and Positive Bars Differently. https://r-graphics.org/recipe-bar-graph-color-neg \cr
Gross C, Ottolinger P (2016).\emph{ggThemeAssist: Add-in to Customize 'ggplot2' Themes}. R package version 0.1.5, <URL: https://CRAN.R-project.org/package=ggThemeAssist>.
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
