\name{crab}
\alias{crab}

\title{
  Brockmann's crab data
}

\description{
  Abstract from original paper: Horseshoe crabs arrive on the beach in pairs and
  spawn in the high intertidal during the springtime, new and full moon high
  tides. Unattached males also come to the beach, crowd around the nesting
  couples and compete with attached males for fertilizations. Satellite males
  form large groups around some couples while ignoring others, resulting in a
  nonrandom distribution that cannot be explained by local environmental
  conditions or habitat selection. In experimental manipulations, pairs that had
  satellites regained them after they had been removed whereas pairs with no
  satellites continued nesting alone, which means that satellites were not
  simply accumulating around the pairs that had been on the beach the longest.
  Manipulations also revealed that satellites were not just copying the
  behaviour of other males. Based on the evidence from observations and
  experiments, the most likely explanation for the nonrandom distribution of
  satellite males among nesting pairs is that unattached males are
  preferentially attracted to some females over others. Females with many
  satellites were larger and in better condition, but did not lay more eggs,
  than females with few or no satellites.\cr\cr
  \code{satellites} response variable; number of satellites around female
    crab\cr
  \code{color} color of crab\cr
  \code{spine} condition of spine\cr
  \code{weight} weight of crab\cr
  \code{width} width of carapace
}

\format{
  173 observations on 5 variables.
}

\source{
  https://onlinecourses.science.psu.edu/stat504/node/169
}

\references{
  Brockmann, H. (1996), "Satellite male groups in horseshoe crabs,"
  \emph{Ethology}, \bold{102}-1, pp. 1-21.
}

\examples{
data(crab)
}

\keyword{ crab }
