% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor2color.R
\name{factor2color}
\alias{factor2color}
\title{Assign colours to factor vector}
\usage{
factor2color(x, colors = NULL)
}
\arguments{
\item{x}{A factor vector.}

\item{colors}{The colours to use. Defaults to a qualitative colour scheme;
either \code{"Set3"} from \code{RColorBrewer} if available, or
\code{\link{rainbow}} otherwise.}
}
\value{
A character vector of colours.
}
\description{
This function takes a factor vector and returns suitable colours
  representing the factor levels. Default is to try to use
  \code{RColorBrewer} for colours, and \code{\link{rainbow}} otherwise. Can
  provide custom colours.
}
\details{
Uses the \code{RColorBrewer} package if installed. Coerces \code{x}
  to factor with a warning.
}
\examples{
plot(iris[, c("Petal.Length", "Petal.Width")], pch = 21,
  bg = factor2color(iris$Species))
legend("topleft", legend = levels(iris$Species),
  fill = factor2color(as.factor(levels(iris$Species))))

}
\seealso{
\code{\link{cont2color}}
}

