% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singleTrial.R
\name{runSingleTrial}
\alias{runSingleTrial}
\title{Frequentist Confidence-Adaptive Trial Simulation}
\usage{
runSingleTrial(
  sim.no = 0,
  inputs = NULL,
  save.plot = FALSE,
  save.text = TRUE,
  show = "BENEFIT",
  directory = "",
  reproduce = FALSE,
  verbose = FALSE,
  seed = NULL
)
}
\arguments{
\item{sim.no}{Simulation number, when running mutiple simulations of a trial.}

\item{inputs}{A list of items fed to the function which parameterize the trial to be simulated.
An example parameter list can be loaded using \code{data(inputs)}.}

\item{save.plot}{Whether or not to save confidence curve plot with the result.TRUE (yes) or FALSE (no).
When running multiple simulations, \code{FALSE} is recommended. If \code{TRUE}, files will be saved to the specified directory.
The filename is automatically generated according to trial settings. Default is FALSE. Passed to \code{makeConfidenceCurves}.}

\item{save.text}{Whether or not to save results to directory. Default is TRUE.}

\item{show}{If saving confidence curves, what to show on the confidence density plot. Options are "BENEFIT" (default), "LMB" (lack of meaningful benefit),
"MB" (meaningful benefit) or "EQUIV" (equivalence). Passed to \code{makeConfidenceCurves}.}

\item{directory}{Working directory. Used to save Random State, and trial results. A subdirectory is created based on the current node
to allow for parallel computing across multiple nodes. Random State is checkpointed throughout the code and saved in the subdirectory 'directory/node/'.
Results are saved in the same places as the Random States. If \code{save.text == FALSE} nothing is saved to \code{directory}.}

\item{reproduce}{To reproduce a result from saved Random States. If setting as TRUE, make sure the directory parameter points to the location (the node subdirectory)
where the Random States are saved. The results will be saved to this directory. If set as FALSE (default), results and Random States are saved to the node subdirectory.}

\item{verbose}{Whether to print out text (TRUE) or not (FALSE). Useful to observe the trial process and decision-making while the simulation is running.
Not recommended if running a high number of simulations.}

\item{seed}{Option to set the seed. Default is NULL.}
}
\value{
Object where each line is the result of confidence analysis for a given arm, at a given stage.
The number of lines is the number experimental treatments * number of stages, e.g., A two-arm-two-stage trial returns a two-line object.
However, if the trial is stopped after the first stage, only one line is returned.

Attributes in output object:
\itemize{
\item{sim.no: simulation number}
\item{arm: arm number starting from 2 as 1 is control}
\item{interim.arm: stage number of this arm (will differ from interim.total if arm was added later)}
\item{interim.total: interim number for trial}
\item{mean: point estimate}
\item{standard.error: standard error associated with point estimate}
\item{resp.ctrl: for binary data, resulting control response rate}
\item{resp.trmt: for binary data, resulting treatment response rate}
\item{conf.benefit: confidence in treatment benefit}
\item{conf.lack.meaningful.benefit: confidence in lack of meaningful benefit}
\item{action: Decision taken at this analysis point e.g. stop early, continue}
\item{N.looks: Number of looks (analysis points) in this trial design}
\item{misc: Information passed into getparlist function by the 'special' parameter. Can be anything of interest}
\item{N.arm: Number recruited to this treatment arm}
\item{N.pair: Number of patients in this two-arm (pairwise) analysis against control}
\item{N.known: Number of patients with a known outcome (prespecified in trial settings)}
\item{N: Total number of patients recruited so far. Will be different from N.known if there is a follow-up period.}
}
}
\description{
Simulates a group sequential clinical trial whose result is evaluated via frequentist confidence analysis.
}
\details{
Run simulations of a confidence-based adaptive clinical trial for any number of arms and stages.
At each analysis point, the confidence in treatment benefit and futility is evaluated and arms may be dropped or continued based on the trial settings.
The trial may also be run perpetually, with new treatment arms being added once arms are dropped, as an adaptive platform trial.
The confidence-based thresholds are derived using an alpha spending function, or specified with a fixed alpha.
}
\examples{
# Example of input list to generate a two-arm-two-stage trial with binary outcome data

inputs <- list(
 outcome.type = "BINARY", # binary outcome data
 estimator.type = 'risk diff', # primary outcome is risk difference
 lmb.threshold = 0.1, # risk difference < 0.1 lacks meaningful benefit
 multiarm.mode='MONITOR FUTILITY', # only monitor for futility
 alpha = 0.0125, # fixed alpha threshold to determine treatment efficacy
 alloc.ratio = c(1,1), # allocation ratio
 num.per.block = c(1,1), # number per block for blocked allocation
 final.visit = 0, # time in days after which follow-up data becomes available
 ppm = rep(25, 15), # patients accrued each month for the entire trial period.
 looks = c(107, 214), # number of patients accrued at each look time, nmax = 214.
 perpetual=FALSE, # not a perpetual trial.
 resprate =  c(0.5, 0.6), # response rate for each arm
 lmb.conf.thres=0.95, # treatment arm is futility is the confidence in LMB is greater than 0.95
 special = paste0(0.5, '_', 0.6) # passing the response rates to special to add to the output
)
# run a single simulation with these settings
conf <- runSingleTrial(input=inputs, save.plot=FALSE,
save.text=FALSE, verbose=TRUE, directory = '')
}
\references{
Frequentist confidence analysis is based on Marschner (2024) \doi{https://doi.org/10.1002/sim.10000}.
}
\seealso{
\code{\link[confidenceCurves:makeConfidenceCurves]{confidenceCurves::makeConfidenceCurves()}}
}
