% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{data_tosh}
\alias{data_tosh}
\title{Data from Tosh}
\format{
An object of class \code{data.frame} with 15 rows and 3 columns.
}
\source{
Tosh, J. J., and J. W. Wilton. (1990).
Degree of connectedness in mixed models.
Proceedings of the 4th World Congress on Genetics applied to Livestock Production, 480-483.
Page 481.
}
\usage{
data_tosh
}
\description{
Data from Tosh
}
\details{
A dataframe with 3 treatment factors.
The treatment combinations form 2 disconnected groups.
}
\examples{
cbind(data_tosh,
      .group=con_check(data_tosh, ~ a + b + c))
data_tosh = transform(data_tosh,
  y = rnorm(nrow(data_tosh), mean=100))
library(connected)
con_view(data_tosh, y ~ b * c)

}
\keyword{datasets}
