% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/console_menu.R
\name{console_menu}
\alias{console_menu}
\title{Prints out a menu from a character vector and waits for user selection}
\usage{
console_menu(
  chr_vector,
  instruction_msg = "Type the number in the console your choice and press enter: ",
  quit_key = "q",
  quit_message = paste0("To quit please type ", quit_key, " and press return."),
  return_number = TRUE,
  test_args = list(test_mode = FALSE, test_input = NA_character_)
)
}
\arguments{
\item{chr_vector}{character vector.}

\item{instruction_msg}{character.  Message shows under the menu selection}

\item{quit_key}{character.  Character value for the user to quit the menu}

\item{quit_message}{character.  Character value to explain how to quit the menu}

\item{return_number}{logical.  TRUE return number choice.  FALSE returns the index of chr_vector}

\item{test_args}{list(test_mode logical, test_input character).  Only use for testing.}
}
\value{
character
}
\description{
Prints out a menu from a character vector and waits for user selection
}
\examples{
\dontrun{
console_menu(c("Eat", "sleep", "code", "repeat"))

console_menu(c("Eat", "sleep", "code", "repeat"),
             "What would you like to do?",
             "quit",
             "Type quit to exit")

# Example code on how the function could be used
user_choice <- console_menu(c("Eat", "sleep"))

switch_result <- switch(
    user_choice,
    "1" = # code here,
    "2" = # code here,
    "q" = # exit code here
)
# Example code if the function returned the name in the character vector
user_choice <- console_menu(c("Eat", "sleep"), return_number = FALSE)

switch_result <- switch(
    user_choice,
    "Eat" = # code here,
    "sleep" = # code here,
    "q" = # exit code here
)
}
}
