% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abcdchk.R
\name{abcdchk}
\alias{abcdchk}
\title{State-space matrices check.}
\usage{
abcdchk(a, b, c, d)
}
\arguments{
\item{a}{An n x n matrix}

\item{b}{An n x m matrix}

\item{c}{An p x n matrix}

\item{d}{An p x m matrix}
}
\value{
Returns an empty string if matrix dimensions are consistent. Otherwise it returns the associated error message
}
\description{
\code{abcdchk} verifies the dimensions of A,B,C,D matrices in its arguments, to ascertain that they are correctly defined.
}
\details{
This is a utility function that is always invoked by other functions to
ascertain the dimensions of the arguments \code{a,b,c,d} and returns a message
if there is an ill-defined entry.
}
\examples{
A <- rbind(c(0,1), c(-10000,-4))
B <- rbind(0,1)
C <- rbind(c(1,0), c(0,1))
D <- rbind(0,0)
message <-  abcdchk(A,B,C,D)

}
