% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdata.R
\name{ssdata}
\alias{ssdata}
\title{Retrieve State-space data}
\usage{
ssdata(sys1)
}
\arguments{
\item{sys1}{an LTI system object of tf, ss or zpk classes}
}
\value{
Returns a list object of \code{ss} class containing A, B, C and D matrices
}
\description{
\code{ssdata} retrieves the model for a state-space system from a \code{sys} object
}
\details{
\code{ssdata} retrieves a model object for a state-space system, from a \code{sys} object of tf, ss and zpk classes
}
\examples{
sys1 <- tf(c(1), c(1,2,1))
 ssdata(sys1)
 A <- rbind(c(-2, -1), c(1,0)); B <- rbind(1,0);
 C <- cbind(0,1); D <- 0;
 sys2 <- ss(A,B,C,D)
 ssdata(sys2)
 ss2zp(ssdata(zpk(NULL, c(-1,-1), 1)))

}
\seealso{
\code{\link{ss}} \code{\link{tfdata}} \code{\link{zpkdata}}
}
