% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/departure_best.R
\name{departure_best}
\alias{departure_best}
\title{Departures from the best country}
\usage{
departure_best(oriTB, timeName = "time", indiType = "highBest")
}
\arguments{
\item{oriTB}{original dataset (tibble) with time by country values.}

\item{timeName}{string with the name of the time variable in oriTB.}

\item{indiType}{the type of indicator 'highBest' (default) or 'lowBest'.}
}
\value{
a list with component res which contains the departures from the best performer (for each country and for each year)
       and the cumulated differences over years.
}
\description{
For each country the departure from the best performing Member State  is calculated.
Then, differences are cumulated over years.
}
\examples{

# Example 1
# Sorted dataframe in the format years by countries:
require(tibble)
testTB <- dplyr::tribble(
~time, ~countryA ,  ~countryB,  ~countryC,
2000,     0.8,   2.7,    3.9,
2001,     1.2,   3.2,    4.2,
2002,     0.9,   2.9,    0.1,
2003,     1.3,   2.9,    1.0,
2004,     1.2,   3.1,    4.1,
2005,     1.2,   3.0,    4.0
)

# Departures from the best country according to the indicator higher is the best:
mySTB <- departure_best(testTB,timeName="time",indiType = "highBest")
# Differences from the best country for each year:
mySTB$res$raw_departures
# Sum of the cumulated differences for each country:
mySTB$res$cumulated_dif

# Departures from the best country according to the indicator lower is the best:
mySTB1 <- departure_best(testTB,timeName="time",indiType = "lowBest")

# Example 2
# Departures from the best country for the emp_20_64_MS Eurofound dataset:
mySTB2 <- departure_best(emp_20_64_MS,timeName="time",indiType = "highBest")
mySTB3 <- departure_best(emp_20_64_MS,timeName="time",indiType = "lowBest")


}
\references{
{ \url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
