% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convoSPAT_simulate.R
\name{NSconvo_sim}
\alias{NSconvo_sim}
\title{Simulate data from the nonstationary model.}
\usage{
NSconvo_sim(
  grid = TRUE,
  y.min = 0,
  y.max = 5,
  x.min = 0,
  x.max = 5,
  N.obs = 20^2,
  sim.locations = NULL,
  mc.kernels.obj = NULL,
  mc.kernels = NULL,
  mc.locations = NULL,
  lambda.w = NULL,
  tausq = 0.1,
  sigmasq = 1,
  beta.coefs = 4,
  kappa = NULL,
  covariates = rep(1, N.obs),
  cov.model = "exponential"
)
}
\arguments{
\item{grid}{Logical; indicates of the simulated data should fall on a
grid (\code{TRUE}) or not (\code{FALSE}).}

\item{y.min}{Lower bound for the y-coordinate axis.}

\item{y.max}{Upper bound for the y-coordinate axis.}

\item{x.min}{Lower bound for the y-coordinate axis.}

\item{x.max}{Upper bound for the y-coordinate axis.}

\item{N.obs}{Number of simulated data values.}

\item{sim.locations}{Optional \code{N.obs} x 2 matrix; allows the user
to specify the locations of the simulated data.}

\item{mc.kernels.obj}{Object from the \code{\link{f_mc_kernels}} function.}

\item{mc.kernels}{Optional specification of mixture component kernel
matrices.}

\item{mc.locations}{Optional specification of mixture component locations.}

\item{lambda.w}{Scalar; tuning parameter for the weight function.}

\item{tausq}{Scalar; true nugget variance.}

\item{sigmasq}{Scalar; true process variance.}

\item{beta.coefs}{Vector of true regression coefficients. Length must
match the number of columns in \code{covariates}.}

\item{kappa}{Scalar; true smoothness.}

\item{covariates}{Matrix with \code{N.obs} rows, corresponding to
covariate information for each of the simualted values.}

\item{cov.model}{A string specifying the model for the correlation
function; defaults to \code{"exponential"}.
Options available in this package are: "\code{exponential}",
\code{"matern"}, and \code{"gaussian"}.}
}
\value{
A list with the following components:
\item{sim.locations}{Matrix of locations for the simulated values.}
\item{mc.locations}{Mixture component locations used for the simulated
data.}
\item{mc.kernels}{Mixture component kernel matrices used for the simulated
data.}
\item{kernel.ellipses}{\code{N.obs} x 2 x 2 array, containing the kernel
matrices corresponding to each of the simulated values.}
\item{Cov.mat}{True covariance matrix (\code{N.obs} x \code{N.obs})
corresponding to the simulated data.}
\item{sim.data}{Simulated data values.}
\item{lambda.w}{Tuning parameter for the weight function.}
}
\description{
\code{NSconvo_sim} simulates data from the nonstationary model, given
mixture component kernel matrices. The function requires either a mixture
component kernel object, from the function f.mc.kernels(), or a direct
specification of the mixture component locations and mixture component
kernels.
}
\examples{
\dontrun{
NSconvo_sim( grid = TRUE, y.min = 0, y.max = 5, x.min = 0,
x.max = 5, N.obs = 20^2, sim.locations = NULL, mc.kernels.obj = NULL,
mc.kernels = NULL, mc.locations = NULL, lambda.w = NULL,
tausq = 0.1, sigmasq = 1, beta.coefs = 4, kappa = NULL,
covariates = rep(1,N.obs), cov.model = "exponential" )
}

}
