% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulareg.R
\name{copulareg}
\alias{copulareg}
\title{copulareg}
\usage{
copulareg(
  y,
  x,
  var_type_y,
  var_type_x,
  distr_x = NULL,
  distr_y = NULL,
  dvine = FALSE,
  family_set = c("gaussian", "clayton", "gumbel")
)
}
\arguments{
\item{y}{A vector of n observations of the (univariate)
outcome variable y}

\item{x}{A (n x p) matrix of n observations of p covariates}

\item{var_type_y}{A character that has to be specified as "d" or "c"
to indicate whether y is discrete or continuous, respectively.}

\item{var_type_x}{A vector of p characters that have to take the value
"c" or "d" to indicate whether each margin of the covariates is discrete
or continuous.}

\item{distr_x}{Internally created object that contains a nested list.
The first element of the 'outer' list is a list where each element
is a distribution object similar to that created by ecdf, the second
element is a function 'transform' that takes a matrix of values of x, 
and returns the corresponding cumulative distributions F(x).}

\item{distr_y}{Similar to distr_x, but for the outcome y.}

\item{dvine}{Logical variable indicating whether the function should fit
a canonical d-vine to (y, x) with the ordering (x_1, ..., x_p, y).}

\item{family_set}{A vector of strings that specifies the set of
pair-copula families that the fitting algorithm chooses from. For an
overview of which values that can be specified, see the documentation
for \link[rvinecopulib]{bicop}.}
}
\value{
A copulareg object. Consists of 'model', an rvinecopulib
'vinecop' object for the copula-model for (x_1, ..., x_p, y),
a hash table containing all of the conditionals for the model (for the
training set), objects distr_x and distr_y that contain the marginal
distributions of the covariates and the outcome, and y, the y-values for
the training data.
}
\description{
This function fits joint distributions with an R-vine
pair copula structure, that is constructed in a specific way so that
the conditional density and distribution of the variable y can be
computed explicitly.
}
