% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lockdown.R
\name{corona_lockdown}
\alias{corona_lockdown}
\title{Draw multiple smoothed graphs of new daily cases, with lockdown date, if present}
\usage{
corona_lockdown(
  pdf = FALSE,
  minpeople = 4e+06,
  mincases = 200,
  cols = 7,
  striptextsize = 10,
  textsize = 10,
  legendx = 0.94,
  legendy = 0.02
)
}
\arguments{
\item{pdf}{print to PDF}

\item{minpeople}{Minimum population for the country}

\item{mincases}{Minimum number of COVID-19 cases}

\item{cols}{Number of columns to display, default = 7}

\item{striptextsize}{size of text in country names}

\item{textsize}{Size of text header}

\item{legendx}{X position of legend}

\item{legendy}{Y position of legend}
}
\description{
By default limited to countries with population > 4M, and over 200 cases.
This may take over 5s to run, depending on your hardware.
}
\examples{
\dontrun{
corona_lockdown( cols=14 )  
}
}
\keyword{corona}
\keyword{lockdown}
\keyword{smoothed}
