##
## compare keyness() results against data from reference implementation (Evert 2022)
##
library(corpora)

## reference data (test code follows at bottom of script)
######################################################################

MRSAKeywords <-
structure(list(lemma = c("10-mal", "100-fach", "500-fach", "ABs", 
"Abhusten", "Abstrich", "Abszess", "Abwehrtrick", "Achso", "Achterhoek", 
"Acinetobacter", "Acinetobacter-Stamm", "Agrar-Lobby", "Ahlheit", 
"Aktivierungslink", "Allergiehäufigkeit", "Allerweltskeim", 
"Allgemeinstation", "Ambroxol", "Andere", "Anderen", "Ankündigungsfrist", 
"Ansatzweise", "Ansteckung", "Ansteckungszahl", "Antbiotika", 
"Antibiogramm", "Antibios", "Antibiotika", "Antibiotika-Einnahme", 
"Antibiotika-Einsatz", "Antibiotika-Forschung", "Antibiotika-Gabe", 
"Antibiotika-Gruppe", "Antibiotika-Hersteller", "Antibiotika-Klasse", 
"Antibiotika-Kris", "Antibiotika-Monitoring", "Antibiotika-Resistenz", 
"Antibiotika-Resistenz-Strategie", "Antibiotika-Resistenzstrategie", 
"Antibiotika-Rezept", "Antibiotika-Therapie", "Antibiotika-Verordnung", 
"Antibiotika-Verschreibung", "Antibiotika-resistent", "Antibiotikabehandlung", 
"Antibiotikadose", "Antibiotikaeinnahme", "Antibiotikaeinsatz", 
"Antibiotikaforschung", "Antibiotikagabe", "Antibiotikagruppe", 
"Antibiotikaklasse", "Antibiotikamissbrauch", "Antibiotikaresistenz", 
"Antibiotikas", "Antibiotikastrategie", "Antibiotikatherapie", 
"Antibiotikaverbrauch", "Antibiotikaverordnung", "Antibiotikaverwendung", 
"Antibiotikawirkstoff", "Antibiotikum", "Antibiotikum-Resistenz", 
"Antiobiotika", "Apfalter", "Artengrenze", "Artgerechte", "Artikel", 
"Arzt", "Arzteinkommen", "Atemsystem", "Atemwegsentzündung", 
"Augusta-Klinik", "Ausbreitung", "Avatarbild", "Baby-Drama", 
"Babystation", "Bagatellerkrankung", "Bakterie", "Bakterien-Stamm", 
"Bakterienart", "Bakterienfamilie", "Bakteriengen", "Bakterienherd", 
"Bakterieninfektion", "Bakterienkiller", "Bakterienkolonie", 
"Bakterienresistenz", "Bakterienstamm", "Bakterienvariante", 
"Bakterienwachstum", "Bakterienzahl", "Bakteriophage", "Bakteriophagen", 
"Bakterium", "Basishygiene", "Bauern-Lobby", "Behandlung", "Behandlungsregime", 
"Bekämpfungsmethode", "Berghäuser", "Bestimmtenantibiotikum", 
"Beta-Laktamase", "BfR", "Billigpersonal", "Bindungsprotein", 
"Biofilm", "Biotier", "Biotierhaltung", "Bittersalz", "Blaha", 
"Blutdruckmesse", "Blutvergiftung", "Bodenbakterium", "Bowinkelmann", 
"Brandverletzte", "Breitband-Antibiotikum", "Breitbandantibiotikum", 
"Bremen-Mitte", "Brustmuskulatur", "Böggemann", "Bülach", "C-reaktiv", 
"CDU-Gesundheitsexperte", "CORRECT", "CVUA", "Campylobacter-Bakterie", 
"Cannabis-Medikament", "Carbapenem", "Carbapenem-Antibiotikum", 
"Carbapenem-Resistenz", "Carbapenem-resistent", "Carbapenemase", 
"Carbapeneme", "Carbapenemen", "Cephalosporine", "Charité", 
"Chefarzt", "Chinolone", "Chlamydia", "Chloramphenicol", "Clindamycin", 
"Clostridium", "Colistin", "Colistin-Resistenz", "Curti", "DART", 
"DDD", "DGHM", "DGKH", "Darm", "Darm-Keim", "Darmbakterie", "Darmbakterium", 
"Darmbewohner", "Darmflora", "Darmkeim", "Dekolonisierungsmaßnahme", 
"Demzufolge", "Deshalb", "Desinfektion", "Desinfektionsmittel", 
"Desinfektor", "Desweiteren", "Dettenkofer", "Diakonie-Krankenhaus", 
"Dosiergerät", "Dox", "Doxy", "Drei-Bett-Zimmer", "Durchfall", 
"E-Coli-Bakterie", "ECDC", "EHEC", "ENDO-Klinik", "ESBL", "ESBL-Bakterie", 
"ESBL-Bildner", "ESBL-Gene", "ESBL-Keim", "ESBL-Klebsiellen", 
"ESBL-Resistenzgen", "ESBL-bildend", "ESBL-produzierend", "ESBLbilden", 
"Egal", "Eigentlich", "Eingangsscreening", "Einmalkittel", "Einsatz", 
"Einzelgabe", "Eisenspeicher", "Eitererreger", "Eiterherd", "Eiterung", 
"Eiweißproduktion", "Ekblom", "Endokarditis", "Enterobakterien", 
"Enterokokken", "Entzündung", "Enzym", "Erbgutabschnitt", "Erkrankung", 
"Erkältung", "Erkältungshusten", "Erreger", "Escherichia", 
"Experte", "Fall", "Falschdiagnose", "Fleisch", "Fluorchinolone", 
"Folgeoperation", "Forenteilnehmer", "Forist", "Forscher", "Fosfomycin", 
"Frieden", "Frühchen", "Frühchen-Station", "Frühchenstation", 
"Frühgeborene", "Gasbrand", "Gastmeier", "Gefahr", "Gemäss", 
"Gen", "Generika", "Gentransfer", "Gesundheit", "Gesundheitsamt", 
"Gesundheitsstaatsrat", "Grossteil", "Grünen", "Handhygiene", 
"Hans-Iko", "Harnweg", "Harnweginfektion", "Harnwegsentzündung", 
"Harnwegsinfekt", "Harnwegsinfektion", "Hausarzt", "Haut", "Hautbakterie", 
"Hautbarriere", "Hochleistungszucht", "Humanbereich", "Humanmedizin", 
"Hygiene", "Hygiene-Experte", "Hygiene-Fachkraft", "Hygiene-Maßnahme", 
"Hygiene-Standard", "Hygienebeauftragte", "Hygieneexperte", "Hygienefachkraft", 
"Hygienefrage", "Hygienemanagement", "Hygienemangel", "Hygienemaßnahme", 
"Hygienepersonal", "Hygieneregel", "Hygieneskandal", "Hygienestandard", 
"Hygieneverordnung", "Hygienevorschrift", "Hygieniker", "Händedesinfektion", 
"Händehygiene", "Händewaschen", "Images", "Immunsystem", "Infekt", 
"Infektiologe", "Infektiologie", "Infektion", "Infektionserreger", 
"Infektionsforschung", "Infektionsgefahr", "Infektionshygiene", 
"Infektionskrankheit", "Infektionsprävention", "Infektionsrate", 
"Infektionsrisiko", "Infektionsschutzgesetz", "Infektionsspezialist", 
"Infektionszahl", "Institute", "Intensivpatient", "Intensivstation", 
"Interreg", "Isolationsmaßnahme", "KEYSTONE", "KISS", "KPC", 
"KPC-Keim", "KRINKO", "Kaase", "Katheter", "Keim", "Keim-Alarm", 
"Keim-Ausbruch", "Keim-Kris", "Keim-Skandal", "Keimausbruch", 
"Keimbefall", "Keimbekämpfung", "Keimbelastung", "Keimflora", 
"Keiminfektion", "Keimkris", "Keimproblem", "Keimskandal", "Keimträger", 
"Killer-Keim", "Killerbakterie", "Killerkeim", "Klebsiella", 
"Klebsiella-Bakterie", "Klebsiellen", "Klinik", "Klinik-Keim", 
"Klinik-Mitarbeiter", "Klinikhygiene", "Klinikhygieniker", "Klinikinfektion", 
"Klinikkeim", "Klinikpersonal", "Klinikum", "Koch-Institut", 
"Koch-Instituts", "Kranke", "Krankenhaus", "Krankenhaus-Aufenthalt", 
"Krankenhaus-Hygiene", "Krankenhaus-Hygieniker", "Krankenhaus-Infektion", 
"Krankenhaus-Keim", "Krankenhaus-MRSA", "Krankenhausbakterie", 
"Krankenhauserreger", "Krankenhaushygiene", "Krankenhaushygieniker", 
"Krankenhausinfektion", "Krankenhauskeim", "Krankenhausmediziner", 
"Krankenhauspatient", "Krankenhausskandal", "Krankheit", "Krankheitserreger", 
"Krankheitskeim", "Kurbelradio", "Körper", "Labor", "Leser-Kommentar", 
"Linezolid", "Linktext", "Lungenentzündung", "Lutschtablett", 
"MRE", "MRGN", "MRGN-Erreger", "MRGN-Keim", "MRSA", "MRSA-Bakterie", 
"MRSA-Bakterium", "MRSA-Erkrankung", "MRSA-Erreger", "MRSA-Fall", 
"MRSA-Infektion", "MRSA-Keim", "MRSA-Patient", "MRSA-Problem", 
"MRSA-Stamm", "MRSA-Test", "MRSA-Träger", "MRSA-frei", "Massenbehandlung", 
"Massentierhaltung", "Mastanlage", "Mastbeschleuniger", "Mastbetrieb", 
"Mastfutter", "Maßnahme", "Medikament", "Medizin", "Mediziner", 
"Mensch", "Menscheit", "Methicillin", "Methicillin-resistent", 
"Methicillin-resistente", "Methicillin-resistenten", "Methicillin-resistenter", 
"Methillicin-resistent", "Mikroaufnahme", "Mikrobe", "Mikrobiologe", 
"Mikrobiologie", "Mikroorganism", "Mittel", "Multiresistent", 
"Multiresistente", "Multiresistenz", "Mutation", "NZZ-Konto", 
"Nasenhöhle", "Nasenvorhof", "National", "Nebenwirkung", "Neu-Delhi-Metallo-Beta-Laktamase", 
"Nosokomiale", "Not-Operation", "Notfall-Antibiotikum", "Notfallantibiotikum", 
"ONLINE", "OP", "OP-Wunde", "ORSA", "Omnivoren", "Operation", 
"PDF-Ratgeber", "PETA", "Patient", "Patientenkontakt", "Paul-Ehrlich-Gesellschaft", 
"Penicillin", "Penicillium", "Penizillin", "Penizilline", "Personal", 
"Pflegeheimen", "Pflegepersonal", "Pfleger", "Pflegeschlüssel", 
"Phage", "Phagen", "Phagentherapie", "Pharma-Lobby", "Pharmaindustrie", 
"Pierard", "Plasmide", "Popp", "Posted", "Problem", "Problemkeim", 
"Pseudomonas", "Quell", "RKI", "Redaktionsempfehlung", "Referenzzentrum", 
"Reserve-Antibiotikum", "Reserveantibiotikum", "Reservemedikament", 
"Reservemittel", "Resistent", "Resistente", "Resistenz", "Resistenz-Gen", 
"Resistenzbildung", "Resistenzentwicklung", "Resistenzgen", "Resistenzmechanismus", 
"Resistenzproblem", "Resistenzproblematik", "Resistenzrat", "Resistenzrate", 
"Resistenzrisiko", "Resistenztest", "Risikopatient", "Robert-Koch-Institut", 
"Robert-Koch-Instituts", "Routine-Eingriff", "Routine-OP", "SPIEGEL", 
"SPIEGEL-Verlag", "Schlachtbedingung", "Schleimhaut", "Schwein", 
"Schätzungsweise", "Screening", "Selektionsdruck", "Sendedatum", 
"Sendungshinweis", "Sepsis", "Spital", "Spitalhygiene", "Spitalhygieniker", 
"Spitalinfektion", "Spitalkeim", "Spitalskeim", "Stall", "Stamm", 
"Standardhygiene", "Staphylococcus", "Staphylokokken", "Staphylokokken-Infektion", 
"Staphylokokkus", "Station", "Stattdessen", "Sterillium", "Stoffklasse", 
"Streptokokken", "Studie", "Substanz", "Super-Bakterium", "Super-Erreger", 
"Super-Keim", "Superbakterie", "Superbakterium", "Superbug", 
"Supererreger", "Superinfektion", "Superkeim", "Swissnoso", "Symptom", 
"Teixobactin", "Tetracycline", "The", "Therapie", "Tier", "Tierarzt", 
"Tierhaltung", "Tiermast", "Tierzucht", "Tigecyclin", "Tigezyklin", 
"Todesfall", "Toilettenhygiene", "UKL", "UKSH", "US-Forscher", 
"US-Gesundheitsbehörde", "USA", "Umweltmedizin", "Uniklinik", 
"Uniklinikum", "Universitätsklinikum", "Untersuchung", "Ursache", 
"VRE", "VRE-Keim", "Vancomycin", "Vancomycin-resistent", "Verbreitung", 
"Verordnungspraxis", "Verschreibung", "Virus", "Virus-Grippe", 
"Vor-Antibiotika-Zeit", "WHO", "Wann", "Weltgesundheitsorganisation", 
"Wie", "Wirkstoff", "Wissenschaftler", "Wundabstrich", "Wunddrainage", 
"Wunde", "Wundermedizin", "Wundinfektion", "Wundkeim", "Zastrow", 
"Zellwand", "abtöten", "abwehrgeschwächt", "aeruginosa", "ander", 
"anstecken", "antibakteriell", "antibiotika-resistent", "antibiotikaresistent", 
"antibiotisch", "antimikrobiell", "asymptomatischen", "aureus", 
"ausbreiten", "auslösen", "ausser", "bakteriell", "baumanii", 
"baumannii", "befallen", "behandelbar", "behandeln", "bekannt", 
"bekämpfen", "bereits", "besiedeln", "bis", "bräuchten", "cassandros", 
"coli", "coli-Bakterie", "dahin", "danach", "daraufhin", "derStandard", 
"desinfizieren", "desto", "difficile", "dpa", "durchseuchen", 
"eine", "einschleppen", "einsetzen", "eitrig", "entwickeln", 
"erkranken", "et", "faecalis", "ferner", "for", "gefährlich", 
"gelangen", "geschwächt", "gescreent", "gesund", "glaub", "gramnegativ", 
"harmlos", "helfen", "hierbei", "hierzu", "hochresistent", "hospitalisiert", 
"hygienisch", "häufig", "höchst", "immungeschwächt", "infizieren", 
"infiziert", "isolieren", "jährlich", "jüngst", "klinisch", 
"krank", "krankenhaushygienisch", "krankmachend", "lebensbedrohlich", 
"lieber", "marcescens", "medizinisch", "meiste", "meisten", "mikrobiologisch", 
"mulitresistenten", "multi-resistent", "multiresistent", "nachweisen", 
"nicht-resistent", "nosokomiale", "nosokomialen", "nosokomialer", 
"of", "pneumoniae", "politicon", "post-antibiotisch", "postantibiotisch", 
"potenziell", "resistent", "schliesslich", "schwer", "selbe", 
"selben", "sogenannt", "solange", "sprich", "standard", "sterben", 
"testen", "tödlich", "unempfindlich", "untersuchen", "unwirksam", 
"usw", "verabreichen", "verbreiten", "vermehren", "vermeidbar", 
"verordnen", "verschreiben", "verursachen", "vieleicht", "waschen", 
"weltweit", "wg", "wirken", "wirksam", "wirkungslos", "zB", "zb", 
"zu", "zwischen", "ß-Lactam-Antibiotikum", "ärztlich", "über", 
"überleben", "übertragen"), f1 = c(2L, 3L, 2L, 8L, 2L, 94L, 
30L, 3L, 2L, 2L, 112L, 2L, 2L, 2L, 13L, 2L, 2L, 2L, 2L, 8L, 8L, 
2L, 2L, 73L, 2L, 8L, 20L, 21L, 13L, 11L, 71L, 21L, 28L, 9L, 2L, 
18L, 8L, 2L, 117L, 7L, 17L, 7L, 31L, 17L, 8L, 55L, 21L, 2L, 8L, 
76L, 22L, 33L, 25L, 27L, 8L, 180L, 7L, 7L, 53L, 29L, 11L, 2L, 
2L, 944L, 2L, 19L, 3L, 2L, 2L, 194L, 567L, 2L, 2L, 3L, 2L, 161L, 
19L, 2L, 2L, 2L, 748L, 7L, 70L, 7L, 2L, 2L, 23L, 20L, 3L, 9L, 
143L, 3L, 3L, 3L, 33L, 3L, 342L, 13L, 2L, 360L, 2L, 2L, 7L, 7L, 
7L, 32L, 2L, 2L, 27L, 2L, 3L, 2L, 2L, 3L, 197L, 2L, 3L, 2L, 31L, 
52L, 62L, 2L, 2L, 2L, 2L, 2L, 8L, 2L, 2L, 2L, 12L, 8L, 8L, 13L, 
9L, 89L, 8L, 53L, 110L, 91L, 7L, 2L, 2L, 3L, 35L, 86L, 11L, 3L, 
13L, 2L, 3L, 38L, 174L, 2L, 106L, 41L, 19L, 73L, 112L, 2L, 3L, 
15L, 102L, 108L, 2L, 8L, 8L, 2L, 3L, 2L, 2L, 2L, 75L, 3L, 30L, 
25L, 2L, 118L, 8L, 18L, 3L, 62L, 13L, 7L, 33L, 14L, 7L, 9L, 8L, 
17L, 2L, 399L, 2L, 3L, 14L, 3L, 2L, 2L, 2L, 3L, 42L, 54L, 108L, 
134L, 3L, 211L, 87L, 2L, 665L, 88L, 300L, 533L, 3L, 146L, 24L, 
3L, 3L, 3L, 276L, 7L, 10L, 118L, 26L, 54L, 85L, 3L, 39L, 389L, 
8L, 140L, 9L, 25L, 239L, 137L, 7L, 7L, 34L, 23L, 15L, 25L, 10L, 
7L, 43L, 65L, 87L, 193L, 3L, 3L, 3L, 9L, 107L, 420L, 27L, 7L, 
15L, 12L, 39L, 21L, 46L, 7L, 28L, 63L, 129L, 16L, 37L, 33L, 71L, 
26L, 70L, 57L, 73L, 39L, 55L, 11L, 251L, 106L, 29L, 41L, 780L, 
22L, 26L, 30L, 3L, 143L, 37L, 22L, 48L, 42L, 8L, 25L, 8L, 33L, 
248L, 3L, 7L, 3L, 3L, 31L, 11L, 7L, 16L, 60L, 936L, 9L, 8L, 12L, 
10L, 29L, 23L, 8L, 23L, 3L, 15L, 7L, 7L, 15L, 26L, 23L, 20L, 
43L, 107L, 13L, 40L, 575L, 17L, 3L, 21L, 8L, 23L, 39L, 45L, 210L, 
36L, 25L, 117L, 733L, 3L, 17L, 9L, 11L, 34L, 8L, 10L, 30L, 260L, 
39L, 130L, 269L, 3L, 39L, 3L, 263L, 227L, 32L, 3L, 276L, 142L, 
12L, 14L, 8L, 238L, 3L, 38L, 32L, 11L, 9L, 411L, 39L, 7L, 7L, 
28L, 31L, 78L, 134L, 29L, 17L, 28L, 12L, 13L, 10L, 3L, 138L, 
24L, 12L, 39L, 3L, 250L, 445L, 228L, 240L, 770L, 3L, 56L, 16L, 
60L, 20L, 56L, 9L, 3L, 81L, 99L, 106L, 70L, 294L, 9L, 78L, 61L, 
69L, 13L, 3L, 9L, 11L, 119L, 12L, 8L, 3L, 11L, 9L, 36L, 77L, 
7L, 3L, 3L, 192L, 9L, 3L, 819L, 29L, 12L, 152L, 17L, 33L, 9L, 
213L, 18L, 104L, 94L, 3L, 8L, 32L, 21L, 3L, 108L, 8L, 16L, 15L, 
7L, 536L, 35L, 72L, 155L, 61L, 9L, 60L, 65L, 162L, 12L, 11L, 
3L, 17L, 482L, 24L, 62L, 78L, 73L, 18L, 32L, 9L, 8L, 19L, 8L, 
9L, 77L, 138L, 13L, 3L, 3L, 19L, 9L, 3L, 58L, 112L, 3L, 99L, 
27L, 3L, 3L, 80L, 80L, 30L, 8L, 21L, 12L, 9L, 114L, 143L, 10L, 
258L, 95L, 3L, 17L, 210L, 30L, 3L, 3L, 30L, 315L, 132L, 11L, 
11L, 9L, 41L, 34L, 11L, 11L, 15L, 55L, 10L, 114L, 9L, 13L, 8L, 
184L, 282L, 99L, 132L, 141L, 60L, 9L, 11L, 213L, 3L, 8L, 35L, 
10L, 9L, 174L, 59L, 117L, 76L, 135L, 236L, 219L, 60L, 15L, 47L, 
33L, 171L, 3L, 62L, 195L, 3L, 9L, 120L, 12L, 119L, 12L, 190L, 
220L, 3L, 3L, 188L, 3L, 141L, 8L, 66L, 40L, 134L, 21L, 60L, 574L, 
136L, 55L, 16L, 132L, 81L, 46L, 3L, 257L, 162L, 214L, 9L, 216L, 
18L, 78L, 119L, 76L, 458L, 374L, 215L, 479L, 136L, 43L, 9L, 9L, 
110L, 14L, 27L, 11L, 18L, 8L, 181L, 72L, 26L, 215L, 3L, 14L, 
94L, 355L, 38L, 386L, 225L, 13L, 3L, 11L, 14L, 576L, 220L, 152L, 
22L, 270L, 9L, 78L, 166L, 380L, 10L, 10L, 32L, 3L, 105L, 476L, 
9L, 64L, 392L, 139L, 206L, 292L, 21L, 101L, 278L, 8L, 33L, 112L, 
51L, 3L, 299L, 8L, 35L, 73L, 3L, 14L, 624L, 296L, 10L, 32L, 35L, 
13L, 42L, 98L, 3L, 26L, 24L, 54L, 778L, 9L, 446L, 13L, 27L, 351L, 
9L, 8L, 3L, 580L, 188L, 259L, 135L, 311L, 88L, 9L, 137L, 248L, 
134L, 82L, 114L, 218L, 277L, 3L, 113L, 233L, 3L, 351L, 257L, 
131L, 19L, 8L, 170L, 18L, 9L, 124L, 79L, 195L, 245L), f2 = c(1L, 
1L, 1L, 0L, 1L, 749L, 21L, 1L, 1L, 1L, 6L, 1L, 1L, 1L, 0L, 1L, 
1L, 1L, 1L, 0L, 0L, 1L, 1L, 273L, 1L, 0L, 0L, 2L, 0L, 0L, 10L, 
1L, 1L, 0L, 1L, 1L, 0L, 1L, 8L, 0L, 0L, 0L, 5L, 0L, 0L, 0L, 5L, 
1L, 0L, 28L, 4L, 6L, 1L, 0L, 0L, 15L, 0L, 0L, 6L, 2L, 0L, 1L, 
1L, 367L, 1L, 1L, 1L, 1L, 1L, 5030L, 8468L, 1L, 1L, 1L, 1L, 555L, 
0L, 1L, 1L, 1L, 528L, 0L, 23L, 0L, 1L, 1L, 7L, 1L, 1L, 0L, 14L, 
1L, 1L, 1L, 4L, 1L, 117L, 0L, 1L, 4093L, 1L, 1L, 0L, 0L, 0L, 
23L, 1L, 1L, 13L, 1L, 1L, 1L, 1L, 1L, 60L, 1L, 1L, 1L, 1L, 8L, 
14L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 
2L, 0L, 6L, 328L, 649L, 0L, 1L, 1L, 1L, 16L, 0L, 0L, 1L, 0L, 
1L, 1L, 0L, 252L, 1L, 35L, 23L, 3L, 41L, 76L, 1L, 1L, 0L, 35L, 
91L, 1L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 186L, 1L, 4L, 9L, 1L, 4L, 
0L, 1L, 1L, 3L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 17077L, 1L, 
1L, 0L, 1L, 1L, 1L, 1L, 1L, 4L, 7L, 344L, 222L, 1L, 2190L, 292L, 
1L, 473L, 33L, 6358L, 51849L, 1L, 2788L, 2L, 1L, 1L, 1L, 5684L, 
0L, 0L, 75L, 5L, 8L, 67L, 1L, 5L, 14007L, 0L, 914L, 0L, 10L, 
3926L, 406L, 0L, 0L, 0L, 4L, 1L, 8L, 0L, 0L, 9L, 9L, 480L, 2677L, 
1L, 1L, 1L, 0L, 46L, 403L, 2L, 0L, 0L, 0L, 2L, 3L, 3L, 0L, 5L, 
56L, 18L, 1L, 18L, 17L, 36L, 7L, 58L, 13L, 5L, 1L, 42L, 0L, 369L, 
186L, 18L, 24L, 699L, 9L, 12L, 23L, 1L, 194L, 6L, 6L, 26L, 15L, 
0L, 4L, 0L, 25L, 427L, 1L, 0L, 1L, 1L, 3L, 0L, 0L, 1L, 63L, 805L, 
0L, 0L, 0L, 0L, 2L, 4L, 0L, 10L, 1L, 1L, 0L, 0L, 1L, 2L, 2L, 
0L, 5L, 8L, 0L, 2L, 4169L, 1L, 1L, 0L, 0L, 2L, 1L, 42L, 1640L, 
32L, 0L, 1156L, 7074L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 2L, 28L, 6L, 
20L, 17L, 1L, 12L, 1L, 4445L, 183L, 20L, 1L, 6929L, 2081L, 0L, 
0L, 0L, 230L, 1L, 7L, 2L, 0L, 0L, 13L, 1L, 0L, 0L, 0L, 0L, 2L, 
4L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 201L, 13L, 0L, 37L, 1L, 8640L, 
3025L, 2386L, 2160L, 56155L, 1L, 1L, 0L, 3L, 0L, 1L, 0L, 1L, 
114L, 66L, 67L, 136L, 15183L, 0L, 0L, 3L, 231L, 0L, 1L, 0L, 0L, 
1103L, 0L, 0L, 1L, 0L, 0L, 1L, 168L, 0L, 1L, 1L, 2982L, 0L, 1L, 
5370L, 11L, 0L, 23L, 0L, 1L, 0L, 6018L, 0L, 178L, 588L, 1L, 0L, 
3L, 1L, 1L, 467L, 0L, 0L, 0L, 0L, 29461L, 1L, 9L, 2592L, 55L, 
0L, 36L, 1L, 3L, 0L, 0L, 1L, 1L, 130L, 0L, 5L, 1L, 9L, 3L, 3L, 
0L, 0L, 0L, 0L, 0L, 29L, 233L, 0L, 1L, 1L, 0L, 0L, 1L, 87L, 1166L, 
1L, 109L, 12L, 1L, 1L, 37L, 109L, 0L, 0L, 0L, 0L, 0L, 984L, 1511L, 
0L, 11L, 19L, 1L, 0L, 4746L, 0L, 1L, 1L, 11L, 11882L, 2411L, 
0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 1209L, 0L, 0L, 0L, 2038L, 
6685L, 301L, 242L, 39L, 32L, 0L, 0L, 854L, 1L, 0L, 2L, 0L, 0L, 
1439L, 28L, 437L, 294L, 691L, 7749L, 5373L, 0L, 0L, 3L, 0L, 1753L, 
1L, 63L, 818L, 1L, 0L, 271L, 0L, 462L, 0L, 723L, 6597L, 1L, 1L, 
1461L, 1L, 16L, 0L, 171L, 12L, 90L, 2L, 5L, 18L, 699L, 38L, 0L, 
14L, 6L, 13L, 1L, 11L, 1791L, 5683L, 0L, 113L, 0L, 7L, 680L, 
63L, 7667L, 25471L, 3449L, 31032L, 414L, 0L, 0L, 0L, 33L, 0L, 
0L, 0L, 0L, 0L, 129L, 0L, 6L, 2126L, 1L, 0L, 95L, 16447L, 19L, 
26497L, 1422L, 0L, 1L, 0L, 0L, 9178L, 7085L, 366L, 7L, 5334L, 
0L, 1L, 2322L, 25099L, 0L, 0L, 3L, 1L, 382L, 17545L, 0L, 15L, 
754L, 235L, 1192L, 12982L, 0L, 1048L, 3501L, 0L, 30L, 328L, 0L, 
1L, 4869L, 0L, 0L, 59L, 1L, 0L, 70L, 4029L, 0L, 2L, 5L, 0L, 0L, 
2L, 1L, 0L, 0L, 19L, 244L, 0L, 40469L, 0L, 0L, 24456L, 0L, 0L, 
1L, 13590L, 3635L, 3067L, 98L, 7276L, 484L, 0L, 562L, 6368L, 
781L, 346L, 1272L, 1326L, 4019L, 1L, 1249L, 10671L, 1L, 26227L, 
3154L, 438L, 0L, 0L, 1046L, 0L, 0L, 1651L, 0L, 4494L, 7315L), 
    G2 = c(18.890003767374008, 29.564058156478747, 18.890003767374008, 
    90.849658776963395, 18.890003767374008, 489.76319835728026, 
    272.28744000297519, 29.564058156478747, 18.890003767374008, 
    18.890003767374008, 1234.7116092370443, 18.890003767374008, 
    18.890003767374008, 18.890003767374008, 147.68606184073531, 
    18.890003767374008, 18.890003767374008, 18.890003767374008, 
    18.890003767374008, 90.849658776963395, 90.849658776963395, 
    18.890003767374008, 18.890003767374008, 478.32066655553319, 
    18.890003767374008, 90.849658776963395, 227.32898783636426, 
    225.13673045471057, 147.68606184073531, 124.94637377850879, 
    749.68182979092171, 230.58425500980221, 309.75987821812498, 
    102.21352345747341, 18.890003767374008, 196.73674683580808, 
    90.849658776963395, 18.890003767374008, 1280.4690654504504, 
    79.487499129405677, 193.18599838418089, 79.487499129405677, 
    323.67460565977331, 193.18599838418089, 90.849658776963395, 
    626.82027363249779, 213.29049305401611, 18.890003767374008, 
    90.849658776963395, 746.57722657489239, 227.80178261000265, 
    342.01453281930088, 275.79794642510393, 307.05633041771847, 
    90.849658776963395, 1966.1734985621158, 79.487499129405677, 
    79.487499129405677, 565.17624054386954, 315.03310050940325, 
    124.94637377850879, 18.890003767374008, 18.890003767374008, 
    10290.40474054954, 18.890003767374008, 208.01242518180038, 
    29.564058156478747, 18.890003767374008, 18.890003767374008, 
    606.22485798019693, 2559.7667093469136, 18.890003767374008, 
    18.890003767374008, 29.564058156478747, 18.890003767374008, 
    1090.336759531036, 215.94627056469605, 18.890003767374008, 
    18.890003767374008, 18.890003767374008, 7388.3163515871738, 
    79.487499129405677, 694.80050166052069, 79.487499129405677, 
    18.890003767374008, 18.890003767374008, 228.93830300506204, 
    219.2950949136879, 29.564058156478747, 102.21352345747341, 
    1546.7213281758145, 29.564058156478747, 29.564058156478747, 
    29.564058156478747, 350.14029134857032, 29.564058156478747, 
    3471.3238327970548, 147.68606184073531, 18.890003767374008, 
    1727.4812656348413, 18.890003767374008, 18.890003767374008, 
    79.487499129405677, 79.487499129405677, 79.487499129405677, 
    289.44342392568899, 18.890003767374008, 18.890003767374008, 
    256.69717975433218, 18.890003767374008, 29.564058156478747, 
    18.890003767374008, 18.890003767374008, 29.564058156478747, 
    1991.7281203696766, 18.890003767374008, 29.564058156478747, 
    18.890003767374008, 343.75971464388431, 545.42547258018362, 
    634.45555400604508, 18.890003767374008, 18.890003767374008, 
    18.890003767374008, 18.890003767374008, 18.890003767374008, 
    90.849658776963395, 18.890003767374008, 18.890003767374008, 
    18.890003767374008, 136.31536235620138, 90.849658776963395, 
    90.849658776963395, 147.68606184073531, 102.21352345747341, 
    997.76744353354798, 90.849658776963395, 565.17624054386954, 
    767.36166689535082, 492.36453690436633, 79.487499129405677, 
    18.890003767374008, 18.890003767374008, 29.564058156478747, 
    334.93505021429968, 982.47107340226285, 124.94637377850879, 
    29.564058156478747, 147.68606184073531, 18.890003767374008, 
    29.564058156478747, 432.51395269729869, 1427.0825221044222, 
    18.890003767374008, 1055.0442706209958, 383.32757683047396, 
    198.44105066970843, 684.44741145199146, 1028.8969443086003, 
    18.890003767374008, 29.564058156478747, 170.43259943290067, 
    1011.2306341345175, 962.08078325985844, 18.890003767374008, 
    90.849658776963395, 90.849658776963395, 18.890003767374008, 
    29.564058156478747, 18.890003767374008, 18.890003767374008, 
    18.890003767374008, 544.19301604561997, 29.564058156478747, 
    316.64764392614251, 245.03032872040893, 18.890003767374008, 
    1316.2528073973913, 90.849658776963395, 196.73674683580808, 
    29.564058156478747, 682.6830941012887, 147.68606184073531, 
    79.487499129405677, 375.46163198981486, 159.05847370730996, 
    79.487499129405677, 102.21352345747341, 90.849658776963395, 
    193.18599838418089, 18.890003767374008, 956.47037044840079, 
    18.890003767374008, 29.564058156478747, 159.05847370730996, 
    29.564058156478747, 18.890003767374008, 18.890003767374008, 
    18.890003767374008, 29.564058156478747, 451.0334171466107, 
    571.94868188467763, 741.01350025778174, 1066.4521294754136, 
    29.564058156478747, 1018.2107416382562, 587.47262070510919, 
    18.890003767374008, 6480.0590101851903, 863.88548030384868, 
    1075.2475978030684, 598.23872544087544, 29.564058156478747, 
    531.96325224065754, 258.78872266861367, 29.564058156478747, 
    29.564058156478747, 29.564058156478747, 997.87155731003804, 
    79.487499129405677, 113.57909463559707, 1094.0077146948836, 
    268.30333248275662, 567.74551251920366, 762.81863125863765, 
    29.564058156478747, 412.80639948597411, 1049.1679673142723, 
    90.849658776963395, 786.00259416216409, 102.21352345747341, 
    242.45686909626986, 956.0404295718015, 960.46067370943524, 
    79.487499129405677, 79.487499129405677, 386.86860516491123, 
    238.86234457303823, 162.95805403146969, 247.76763809347841, 
    113.57909463559707, 79.487499129405677, 441.75355171456243, 
    686.63468944901501, 510.96654272624278, 824.63576430240369, 
    29.564058156478747, 29.564058156478747, 29.564058156478747, 
    102.21352345747341, 1037.5845318620416, 3799.2358774810127, 
    292.51438718109108, 79.487499129405677, 170.43259943290067, 
    136.31536235620138, 427.96044407364508, 220.64871826803795, 
    501.33686521077931, 79.487499129405677, 290.41476408704085, 
    554.24317731236761, 1369.519781116363, 174.20880775721403, 
    351.6745247909638, 311.47169288999766, 673.72688331036397, 
    261.60285034223995, 622.7492837762361, 582.60569936278262, 
    796.00335588573796, 434.58376075558664, 494.3725435922787, 
    124.94637377850879, 2071.4091632062759, 831.41883953443448, 
    267.41452672357411, 381.31475283687882, 7503.5949573223506, 
    212.80901828536955, 248.34443730117971, 268.85890450065324, 
    29.564058156478747, 1182.7697050433324, 386.38578031187842, 
    221.04360264917165, 450.97621062097926, 412.5846665846309, 
    90.849658776963395, 261.02635135457098, 90.849658776963395, 
    296.33060661915567, 1985.4564922415711, 29.564058156478747, 
    79.487499129405677, 29.564058156478747, 29.564058156478747, 
    332.37935928266052, 124.94637377850879, 79.487499129405677, 
    174.20880775721403, 514.03666258265412, 9325.545870235248, 
    102.21352345747341, 90.849658776963395, 136.31536235620138, 
    113.57909463559707, 315.03310050940325, 238.86234457303823, 
    90.849658776963395, 221.06983016804699, 29.564058156478747, 
    162.95805403146969, 79.487499129405677, 79.487499129405677, 
    162.95805403146969, 281.26512542238748, 247.56249577899496, 
    227.32898783636426, 457.56544007222743, 1166.3626419194793, 
    147.68606184073531, 439.27910178464094, 3378.3589626273788, 
    185.4686448119057, 29.564058156478747, 238.71342788526476, 
    90.849658776963395, 247.56249577899496, 434.58376075558664, 
    392.23435965050919, 1123.4020666380466, 315.86849479531617, 
    284.26844579718687, 565.59986395641113, 4073.4723184332156, 
    29.564058156478747, 193.18599838418089, 102.21352345747341, 
    124.94637377850879, 377.79343341058467, 90.849658776963395, 
    113.57909463559707, 326.30189514992838, 2829.2974059809394, 
    408.62884551183299, 1372.6135553802135, 2990.7141615998885, 
    29.564058156478747, 388.35878830906836, 29.564058156478747, 
    1043.8364810518472, 2060.4361210719121, 294.8972177284715, 
    29.564058156478747, 897.55971991546858, 586.09314427378172, 
    136.31536235620138, 159.05847370730996, 90.849658776963395, 
    2105.3533494654175, 29.564058156478747, 393.66019409338122, 
    348.85694916137402, 124.94637377850879, 102.21352345747341, 
    4711.9164991754451, 434.58376075558664, 79.487499129405677, 
    79.487499129405677, 318.45287192094673, 352.65291137375425, 
    871.83183055664279, 1500.4535460435518, 329.85114823678953, 
    193.18599838418089, 318.45287192094673, 136.31536235620138, 
    147.68606184073531, 113.57909463559707, 29.564058156478747, 
    1126.0595684911107, 224.99200032165049, 136.31536235620138, 
    338.86990563703569, 29.564058156478747, 663.38024892590647, 
    2599.3594415442249, 1100.2991980170193, 1227.8094440381481, 
    1402.6122546487973, 29.564058156478747, 628.20406522741189, 
    181.80844049778423, 659.9641848979295, 227.32898783636426, 
    628.20406522741189, 102.21352345747341, 29.564058156478747, 
    661.00477235715937, 910.45659031169487, 982.3103664107299, 
    535.51935150779218, 584.13059950640297, 102.21352345747341, 
    890.52408587886669, 671.32197781717059, 465.15235884100298, 
    147.68606184073531, 29.564058156478747, 102.21352345747341, 
    124.94637377850879, 589.48028134215554, 136.31536235620138, 
    90.849658776963395, 29.564058156478747, 124.94637377850879, 
    102.21352345747341, 400.49988814191084, 575.10014882243922, 
    79.487499129405677, 29.564058156478747, 29.564058156478747, 
    780.03458049793392, 102.21352345747341, 29.564058156478747, 
    5253.1113400635168, 282.87141350902601, 136.31536235620138, 
    1609.5330278754332, 193.18599838418089, 366.445298080707, 
    102.21352345747341, 635.79047733601737, 204.56527457716996, 
    819.60948393590797, 531.28830118799203, 29.564058156478747, 
    90.849658776963395, 343.60087411945972, 230.58425500980221, 
    29.564058156478747, 683.33578917682894, 90.849658776963395, 
    181.80844049778423, 170.43259943290067, 79.487499129405677, 
    1113.9625628449194, 389.14499406930872, 765.18737875707541, 
    603.71289109963675, 535.3801024094596, 102.21352345747341, 
    557.28134248887488, 730.99988556290282, 1831.9550647431793, 
    136.31536235620138, 124.94637377850879, 29.564058156478747, 
    185.4686448119057, 5069.0178809643967, 272.87709966079558, 
    671.44036087315123, 879.80432241314043, 776.42943774778371, 
    187.36069981648438, 343.60087411945972, 102.21352345747341, 
    90.849658776963395, 215.94627056469605, 90.849658776963395, 
    102.21352345747341, 754.82536238054081, 1094.7154289638715, 
    147.68606184073531, 29.564058156478747, 29.564058156478747, 
    215.94627056469605, 102.21352345747341, 29.564058156478747, 
    466.55810368311279, 530.15365915354107, 29.564058156478747, 
    844.95304101478791, 258.9920860525566, 29.564058156478747, 
    29.564058156478747, 767.7205323331317, 656.65629078278414, 
    341.25116088136843, 90.849658776963395, 238.71342788526476, 
    136.31536235620138, 102.21352345747341, 579.16957019599158, 
    676.75631206591856, 113.57909463559707, 2897.3499685121487, 
    983.44341928994106, 29.564058156478747, 193.18599838418089, 
    711.47533428176462, 341.25116088136843, 29.564058156478747, 
    29.564058156478747, 293.63749362366184, 803.41533497313492, 
    490.21757630316148, 124.94637377850879, 124.94637377850879, 
    102.21352345747341, 466.76633397315283, 386.86860516491123, 
    124.94637377850879, 124.94637377850879, 170.43259943290067, 
    616.79408905041521, 113.57909463559707, 535.91925590453411, 
    102.21352345747341, 147.68606184073531, 90.849658776963395, 
    861.35089751435601, 948.13626323828862, 686.37368079395037, 
    1029.3030724365694, 1429.89901660743, 565.39472775543322, 
    102.21352345747341, 124.94637377850879, 1396.4692662891687, 
    29.564058156478747, 90.849658776963395, 382.72969188846764, 
    113.57909463559707, 102.21352345747341, 906.81362261505933, 
    563.48147815650884, 771.37800094588545, 493.67145481604314, 
    816.76085605473418, 645.14446199300824, 710.80058857285235, 
    684.0665634365406, 170.43259943290067, 512.64156727573106, 
    375.46163198981486, 822.99715443546233, 29.564058156478747, 
    534.10915850624417, 1259.5960818849255, 29.564058156478747, 
    102.21352345747341, 894.05233932320891, 136.31536235620138, 
    776.70879691866321, 136.31536235620138, 1259.0465135790394, 
    634.35100484306497, 29.564058156478747, 29.564058156478747, 
    1003.6378678414303, 29.564058156478747, 1514.5281059215931, 
    90.849658776963395, 473.55398719593279, 399.24559397164899, 
    1235.3576394633626, 225.13673045471057, 648.8445713497515, 
    6693.8873298938333, 821.92284255250388, 501.26904725524565, 
    181.80844049778423, 1421.2884989701979, 881.36283635156587, 
    461.74891598698605, 29.564058156478747, 2885.5919907898901, 
    755.79463748205535, 662.91435338782048, 102.21352345747341, 
    2070.9919104845339, 204.56527457716996, 842.20763354363885, 
    694.67236298296189, 676.48345013274582, 1913.3277539175508, 
    591.60622945820114, 864.91703492892702, 835.76652051291444, 
    947.09283156792162, 489.61002590587327, 102.21352345747341, 
    102.21352345747341, 1104.7245574918697, 159.05847370730996, 
    307.05633041771847, 124.94637377850879, 204.56527457716996, 
    90.849658776963395, 1663.29483551218, 821.64008030499872, 
    264.81689951619217, 1057.5590120511044, 29.564058156478747, 
    159.05847370730996, 813.13181063378397, 788.46745903669148, 
    360.07775826131945, 608.86647501012112, 1293.9142259622681, 
    147.68606184073531, 29.564058156478747, 124.94637377850879, 
    159.05847370730996, 2536.4074062495811, 606.22968240521232, 
    1120.7838905758681, 218.0922725105128, 995.43163378879649, 
    102.21352345747341, 879.80432241314043, 702.8078239963445, 
    621.89012492606798, 113.57909463559707, 113.57909463559707, 
    343.60087411945972, 29.564058156478747, 695.9729571284438, 
    1302.1592980120861, 102.21352345747341, 653.19902068309602, 
    3127.7110979052241, 1102.486802527299, 1214.0134885564066, 
    654.99013972364014, 238.71342788526476, 477.76747230295302, 
    1258.9823894693777, 90.849658776963395, 288.46848814807424, 
    784.95167547069843, 581.0552319936827, 29.564058156478747, 
    1217.1963951710472, 90.849658776963395, 398.27732228960758, 
    651.99356543717749, 29.564058156478747, 159.05847370730996, 
    7039.8463932904297, 1302.7520855928865, 113.57909463559707, 
    348.85694916137402, 368.16906480535624, 147.68606184073531, 
    478.18730179794818, 1101.0158933153871, 29.564058156478747, 
    295.66152221346789, 272.87709966079558, 531.79287974299905, 
    8397.9565042941322, 102.21352345747341, 522.90885497836427, 
    147.68606184073531, 307.05633041771847, 536.56023741636363, 
    102.21352345747341, 90.849658776963395, 29.564058156478747, 
    2136.4650525237139, 687.23144120163442, 1197.9512898218279, 
    1231.7216789405502, 1061.1711693441325, 517.41187355429361, 
    102.21352345747341, 883.10818517815403, 790.38032038383687, 
    779.21271895032464, 520.52560171998812, 525.23209141264556, 
    1267.4202078521512, 1181.3436975444629, 29.564058156478747, 
    522.4978699797166, 500.41575755662848, 29.564058156478747, 
    497.05072701179438, 1171.1845403839925, 890.54515263763074, 
    215.94627056469605, 90.849658776963395, 977.31068832461006, 
    204.56527457716996, 102.21352345747341, 531.88837036092264, 
    902.01109285500502, 651.27091767773913, 713.29682546447646
    ), LogRatio = c(8.9182703357420987, 9.4036971629123407, 8.9182703357420987, 
    12.268767582826236, 8.9182703357420987, 5.1937624978491064, 
    8.6857773244366818, 9.4036971629123407, 8.9182703357420987, 
    8.9182703357420987, 12.29464621465184, 8.9182703357420987, 
    8.9182703357420987, 8.9182703357420987, 12.936192243739363, 
    8.9182703357420987, 8.9182703357420987, 8.9182703357420987, 
    8.9182703357420987, 12.268767582826236, 12.268767582826236, 
    8.9182703357420987, 8.9182703357420987, 6.2855800636197019, 
    8.9182703357420987, 12.268767582826236, 13.538856746193979, 
    11.285641401390627, 12.936192243739363, 12.704866697632909, 
    10.948858655575524, 12.022606995556835, 12.429232255019478, 
    12.429232255019482, 8.9182703357420987, 11.805795606483688, 
    12.268767582826236, 8.9182703357420987, 11.970358846890553, 
    12.088195337184413, 13.31058775852086, 12.088195337184413, 
    10.699153046438514, 13.31058775852086, 12.268767582826236, 
    14.975720607926, 10.148137877640695, 8.9182703357420987, 
    12.268767582826236, 9.6058025701038048, 10.503232836463258, 
    10.546954213892576, 12.268767582826232, 13.962664455100555, 
    12.268767582826236, 11.72296345807619, 12.088195337184413, 
    12.088195337184413, 11.222332009835949, 11.74201969605037, 
    12.704866697632909, 8.9182703357420987, 8.9182703357420987, 
    9.5431112882405351, 8.9182703357420987, 11.881744459716986, 
    9.4036971629123407, 8.9182703357420987, 8.9182703357420987, 
    3.4884449999466205, 4.2818905871503361, 8.9182703357420987, 
    8.9182703357420987, 9.4036971629123407, 8.9182703357420987, 
    6.3990519948807263, 13.466706960438144, 8.9182703357420987, 
    8.9182703357420987, 8.9182703357420987, 8.683403586251627, 
    12.088195337184413, 9.7662672422970491, 12.088195337184413, 
    8.9182703357420987, 8.9182703357420987, 9.8290029976450128, 
    11.953894245472821, 9.4036971629123407, 12.429232255019482, 
    11.48823067312401, 9.4036971629123407, 9.4036971629123407, 
    9.4036971629123407, 11.077468930591355, 9.4036971629123407, 
    9.7247479728587827, 12.936192243739363, 8.9182703357420987, 
    4.6760410108214199, 8.9182703357420987, 8.9182703357420987, 
    12.088195337184413, 12.088195337184413, 12.088195337184413, 
    8.6490837029267098, 8.9182703357420987, 8.9182703357420987, 
    9.2077769529370848, 8.9182703357420987, 9.4036971629123407, 
    8.9182703357420987, 8.9182703357420987, 9.4036971629123407, 
    9.8881503473657641, 8.9182703357420987, 9.4036971629123407, 
    8.9182703357420987, 12.573622164354653, 10.808087417991675, 
    10.289108031110409, 8.9182703357420987, 8.9182703357420987, 
    8.9182703357420987, 8.9182703357420987, 8.9182703357420987, 
    12.268767582826236, 8.9182703357420987, 8.9182703357420987, 
    8.9182703357420987, 12.82516093135062, 12.268767582826236, 
    12.268767582826236, 12.936192243739363, 12.429232255019482, 
    13.343192423952786, 12.268767582826236, 11.222332009835949, 
    6.609457740644995, 5.3538188644120552, 12.088195337184413, 
    8.9182703357420987, 8.9182703357420987, 9.4036971629123407, 
    9.2866577417221237, 15.615932969212619, 12.704866697632909, 
    9.4036971629123407, 12.936192243739363, 8.9182703357420987, 
    9.4036971629123407, 14.448091282270797, 7.6482483901463887, 
    8.9182703357420987, 9.7662672422970509, 9.0017553212451809, 
    10.659352038380538, 9.0059376550653347, 8.7376980901002792, 
    8.9182703357420987, 9.4036971629123407, 13.13550105196277, 
    9.7110377215766572, 8.4271561357363289, 8.9182703357420987, 
    12.268767582826236, 12.268767582826236, 8.9182703357420987, 
    9.4036971629123407, 8.9182703357420987, 8.9182703357420987, 
    8.9182703357420987, 6.8766776606457345, 9.4036971629123407, 
    10.942117077696469, 9.6058025701038048, 8.9182703357420987, 
    12.900122989031843, 12.268767582826236, 11.805795606483688, 
    9.4036971629123407, 12.339734104180376, 12.936192243739363, 
    12.088195337184413, 14.247393932033667, 13.039285736703468, 
    12.088195337184413, 12.429232255019482, 12.268767582826236, 
    13.31058775852086, 8.9182703357420987, 2.7635472627587294, 
    8.9182703357420987, 9.4036971629123407, 13.039285736703468, 
    9.4036971629123407, 8.9182703357420987, 8.9182703357420987, 
    8.9182703357420987, 9.4036971629123407, 11.420770676271285, 
    11.042598470744302, 6.5144958013160812, 7.455105578278757, 
    9.4036971629123407, 4.8087740953728924, 6.4402230389374555, 
    8.9182703357420987, 8.6723789820193993, 9.5828211012011195, 
    3.7780551705108274, 1.5786067460784916, 9.4036971629123407, 
    3.9307880403575033, 11.474086490803739, 9.4036971629123407, 
    9.4036971629123407, 9.4036971629123407, 3.81962266971856, 
    12.088195337184413, 12.573622164354656, 8.8316432511490746, 
    10.449793577501797, 10.862026225102481, 8.5223416594109604, 
    9.4036971629123407, 11.025653871115701, 3.0128723875200096, 
    12.268767582826236, 5.4788917020481041, 12.429232255019482, 
    9.4614126607686302, 4.146158405548821, 6.6174810079128878, 
    12.088195337184413, 12.088195337184413, 14.289829198354063, 
    10.56596859181122, 11.550538551241612, 9.7662672422970509, 
    12.573622164354656, 12.088195337184413, 10.376320723981037, 
    10.966800229669758, 5.7241232326344722, 4.3908236380826864, 
    9.4036971629123407, 9.4036971629123407, 9.4036971629123407, 
    12.429232255019482, 9.3903387800573235, 8.2408418685532574, 
    11.640736360213189, 12.088195337184413, 13.13550105196277, 
    12.82516093135062, 12.163157394865632, 10.800214574220387, 
    11.913108630626322, 12.088195337184413, 10.55476313710334, 
    8.3498104659328725, 10.988659663633499, 11.640736360213189, 
    9.2006700664428251, 9.1181109150886996, 9.1513515194742645, 
    10.002334600530574, 8.450491374391282, 10.271907290356801, 
    11.921545467774962, 12.900122989031839, 8.5663296717882993, 
    12.704866697632909, 7.6262887772352697, 7.3729825415464942, 
    8.8544944253087863, 8.9416343288076092, 8.3393793163890493, 
    9.4252303244619817, 9.2653690063643666, 8.5574532274611421, 
    9.4036971629123407, 7.7425853232653896, 10.709683713930684, 
    9.9727181197644761, 9.053297129199823, 9.6364993673267207, 
    12.268767582826236, 10.683805082105078, 12.268767582826236, 
    8.5749685900621699, 7.3986261733649208, 9.4036971629123407, 
    12.088195337184413, 9.4036971629123407, 9.4036971629123407, 
    11.351229743018205, 12.704866697632909, 12.088195337184413, 
    11.640736360213189, 8.1114832920783222, 8.3986991471123709, 
    12.429232255019482, 12.268767582826236, 12.82516093135062, 
    12.573622164354656, 11.74201969605037, 10.56596859181122, 
    12.268767582826236, 9.3435761704747708, 9.4036971629123407, 
    11.550538551241612, 12.088195337184413, 12.088195337184413, 
    11.550538551241612, 11.587297101251728, 11.413965498366167, 
    13.538856746193979, 11.164816618787325, 11.842034749915015, 
    12.936192243739363, 12.199226649573156, 5.324318186764625, 
    11.725625257799702, 9.4036971629123407, 13.607569496277993, 
    12.268767582826236, 11.413965498366167, 12.900122989031839, 
    8.2797084456368886, 5.2190612861238694, 8.3487614874274563, 
    13.85373008354739, 4.8822721375047013, 4.9115454254922817, 
    9.4036971629123407, 13.31058775852086, 12.429232255019482, 
    12.704866697632909, 12.704866697632905, 12.268767582826236, 
    12.573622164354656, 11.790113984251416, 11.373554289689661, 
    10.784645771611906, 10.851658733527694, 12.126163187383433, 
    9.4036971629123407, 9.84122929997827, 9.4036971629123407, 
    4.1048339157158278, 8.4913912238187415, 8.8461205499862636, 
    9.4036971629123407, 3.5339048690925661, 4.31271500748778, 
    12.82516093135062, 13.039285736703468, 12.268767582826236, 
    8.2305272571520689, 9.4036971629123407, 10.541200686662277, 
    11.881744459716984, 12.704866697632909, 12.429232255019482, 
    13.111165859834051, 12.900122989031839, 12.088195337184413, 
    12.088195337184413, 14.014194755740636, 14.158584665075811, 
    13.153997395580156, 13.082842102690208, 14.063947790937736, 
    13.31058775852086, 14.014194755740636, 12.82516093135062, 
    12.936192243739363, 12.573622164354656, 9.4036971629123407, 
    7.6404108790971144, 9.0411270835276341, 12.82516093135062, 
    8.2562667992571157, 9.4036971629123407, 3.073072450839609, 
    5.417628493763698, 4.7966744755817601, 5.0140483097562019, 
    1.99381617809461, 9.4036971629123407, 13.416521203269925, 
    13.225698860934347, 12.292813056792884, 13.538856746193979, 
    13.416521203269925, 12.429232255019482, 9.4036971629123407, 
    7.6908291077100266, 8.762646926618352, 8.8391987647509005, 
    7.2280989530548343, 2.4932117962486195, 12.429232255019482, 
    15.475925490467521, 12.316464324857529, 6.4453774310391649, 
    12.936192243739363, 9.4036971629123407, 12.429232255019482, 
    12.704866697632909, 4.9743006352770278, 12.82516093135062, 
    12.268767582826236, 9.4036971629123407, 12.704866697632909, 
    12.429232255019482, 12.786166799734755, 7.0608243656682719, 
    12.088195337184413, 9.4036971629123407, 9.4036971629123407, 
    4.2277129545755665, 12.429232255019482, 9.4036971629123407, 
    5.4690641849086781, 9.5403858348807233, 12.82516093135062, 
    10.879381322348504, 13.31058775852086, 12.662431431312509, 
    12.429232255019482, 3.3642087498504418, 13.390758107204846, 
    7.4088836096276776, 5.542648560758523, 9.4036971629123407, 
    12.268767582826236, 11.396317632546744, 12.022606995556835, 
    9.4036971629123407, 6.0740334192453735, 12.268767582826236, 
    13.225698860934347, 13.13550105196277, 12.088195337184413, 
    2.4021958373015844, 12.74608936035942, 11.113286318147242, 
    4.1219472380059088, 8.3294033805650276, 12.429232255019482, 
    8.9103434199704701, 13.629765242392187, 13.718245727434105, 
    12.82516093135062, 12.704866697632909, 9.4036971629123407, 
    11.725625257799702, 10.067783877161451, 13.796014585691104, 
    11.687657407600684, 13.890962989746363, 11.133049572968673, 
    10.58340318514724, 11.396317632546744, 12.429232255019482, 
    12.268767582826236, 13.466706960438144, 12.268767582826236, 
    12.429232255019482, 9.574786097488289, 7.4277681679154206, 
    12.936192243739363, 9.4036971629123407, 9.4036971629123407, 
    13.466706960438144, 12.429232255019482, 9.4036971629123407, 
    7.6004583493269688, 4.8071153408087319, 9.4036971629123407, 
    8.043142302518369, 9.3188082653258277, 9.4036971629123407, 
    9.4036971629123407, 9.2834029291946294, 7.7374345600893371, 
    14.112042079138782, 12.268767582826236, 13.607569496277993, 
    12.82516093135062, 12.429232255019482, 5.0772611337712839, 
    4.7844464046238748, 12.573622164354656, 12.671763255833817, 
    10.473331350749394, 9.4036971629123407, 13.31058775852086, 
    3.6863327968260373, 14.112042079138782, 9.4036971629123407, 
    9.4036971629123407, 9.5884801230817676, 2.9462501553687446, 
    3.9954381962645598, 12.704866697632909, 12.704866697632909, 
    12.429232255019482, 14.55634417292282, 14.289829198354063, 
    12.704866697632909, 12.704866697632909, 13.13550105196277, 
    13.390758107204842, 12.573622164354656, 4.7803134756929122, 
    12.429232255019482, 12.936192243739363, 12.268767582826236, 
    4.7154895061477422, 3.6165920525446333, 6.5819151702194576, 
    7.3093123539519649, 10.022182236230673, 9.0778001658220333, 
    12.429232255019482, 12.704866697632909, 6.180460319520245, 
    9.4036971629123407, 12.268767582826236, 12.009123766193213, 
    12.573622164354656, 12.429232255019482, 5.1370358942221106, 
    9.2432324907190946, 6.2846824814212017, 6.2365687604380851, 
    5.8298683417792718, 3.1471135999683555, 3.5677355005055693, 
    15.100167978850489, 13.13550105196277, 11.943805427849238, 
    14.247393932033667, 4.8273477924958925, 9.4036971629123407, 
    8.1584043394658146, 6.1154909324090934, 9.4036971629123407, 
    12.429232255019482, 7.0093856900014933, 12.82516093135062, 
    6.2288619941529673, 12.82516093135062, 6.2561027225374897, 
    3.2782358569197827, 9.4036971629123407, 9.4036971629123407, 
    5.2264913410385052, 9.4036971629123407, 11.281568865049323, 
    12.268767582826236, 6.8145224109042717, 9.8772985546857939, 
    8.7529212170493125, 11.285641401390627, 11.640736360213191, 
    13.138014458593057, 5.8238816353309932, 8.7089340672310982, 
    13.225698860934347, 11.373172295898884, 11.829593177665879, 
    9.9655760505204576, 9.4036971629123407, 12.666171407589463, 
    4.7186483212809742, 3.4535746538455743, 12.429232255019482, 
    9.1129794690117034, 13.390758107204846, 11.569034894859001, 
    5.6717201980526477, 8.4500078974963806, 4.1175421190165666, 
    2.0935303490026298, 4.1806772555025482, 2.1651994409701549, 
    6.5788335909999951, 14.624248237424624, 12.429232255019482, 
    12.429232255019482, 9.9031181105095527, 13.039285736703468, 
    13.962664455100555, 12.704866697632909, 13.390758107204846, 
    12.268767582826236, 8.6683221918850908, 15.361213831590829, 
    10.208785477998003, 4.8785836610392277, 9.4036971629123407, 
    13.039285736703468, 8.166118337761219, 2.6494297989131965, 
    9.1626890634085463, 2.0820607160015703, 5.5240754276373298, 
    12.936192243739363, 9.4036971629123407, 12.704866697632909, 
    13.039285736703468, 4.1884388546717526, 3.1752856395795073, 
    6.9163007858923304, 9.7662672422970509, 3.8796521864341567, 
    12.429232255019482, 13.890962989746363, 4.3792202273771403, 
    2.1376863805852282, 12.573622164354656, 12.573622164354656, 
    11.396317632546744, 9.4036971629123407, 6.3230879927030657, 
    2.9788237046458876, 12.429232255019482, 10.238335686612272, 
    7.2384764948282001, 7.4258428037922988, 5.6515291621024639, 
    2.7093169510715032, 13.607569496277993, 4.8125295126644776, 
    4.5290808867761267, 12.268767582826236, 8.3166565944707784, 
    6.6353363724706007, 14.867805268759113, 9.4036971629123407, 
    4.1581590056399724, 12.268767582826236, 14.331051861080578, 
    8.4861593231043138, 9.4036971629123407, 13.039285736703468, 
    11.328311150785057, 4.4168079182333049, 12.573622164354656, 
    11.881744459716984, 10.871620242443278, 12.936192243739363, 
    14.590695677713597, 13.481428466144905, 9.4036971629123407, 
    13.909225196139094, 13.796014585691104, 9.6640868474905712, 
    9.8521673157026974, 12.429232255019482, 1.679273702503477, 
    12.936192243739363, 13.962664455100555, 2.060755288335117, 
    12.429232255019482, 12.268767582826236, 9.4036971629123407, 
    3.6321460844753783, 3.9117873746995686, 4.6180478413835075, 
    8.6414019634733883, 3.6353641296839214, 5.7285574362438103, 
    12.429232255019482, 6.1488832638835156, 3.501668890106671, 
    5.6426650411328536, 6.110915413684495, 4.7070585887097796, 
    5.5793852508477952, 4.3248483675888831, 9.4036971629123407, 
    4.7207180427801045, 2.6671081242182035, 9.4036971629123407, 
    1.9598929443421937, 4.5665377281935386, 6.443790698423463, 
    13.466706960438144, 12.268767582826236, 5.5635760743443576, 
    13.390758107204846, 12.429232255019482, 4.4517454193584491, 
    15.494187696860251, 3.6583846251650534, 3.2841431981335631
    ), LogRatio.G2 = c(0, 9.4036971629123407, 0, 12.268767582826236, 
    0, 5.1937624978491064, 8.6857773244366818, 9.4036971629123407, 
    0, 0, 12.29464621465184, 0, 0, 0, 12.936192243739363, 0, 
    0, 0, 0, 12.268767582826236, 12.268767582826236, 0, 0, 6.2855800636197019, 
    0, 12.268767582826236, 13.538856746193979, 11.285641401390627, 
    12.936192243739363, 12.704866697632909, 10.948858655575524, 
    12.022606995556835, 12.429232255019478, 12.429232255019482, 
    0, 11.805795606483688, 12.268767582826236, 0, 11.970358846890553, 
    12.088195337184413, 13.31058775852086, 12.088195337184413, 
    10.699153046438514, 13.31058775852086, 12.268767582826236, 
    14.975720607926, 10.148137877640695, 0, 12.268767582826236, 
    9.6058025701038048, 10.503232836463258, 10.546954213892576, 
    12.268767582826232, 13.962664455100555, 12.268767582826236, 
    11.72296345807619, 12.088195337184413, 12.088195337184413, 
    11.222332009835949, 11.74201969605037, 12.704866697632909, 
    0, 0, 9.5431112882405351, 0, 11.881744459716986, 9.4036971629123407, 
    0, 0, 3.4884449999466205, 4.2818905871503361, 0, 0, 9.4036971629123407, 
    0, 6.3990519948807263, 13.466706960438144, 0, 0, 0, 8.683403586251627, 
    12.088195337184413, 9.7662672422970491, 12.088195337184413, 
    0, 0, 9.8290029976450128, 11.953894245472821, 9.4036971629123407, 
    12.429232255019482, 11.48823067312401, 9.4036971629123407, 
    9.4036971629123407, 9.4036971629123407, 11.077468930591355, 
    9.4036971629123407, 9.7247479728587827, 12.936192243739363, 
    0, 4.6760410108214199, 0, 0, 12.088195337184413, 12.088195337184413, 
    12.088195337184413, 8.6490837029267098, 0, 0, 9.2077769529370848, 
    0, 9.4036971629123407, 0, 0, 9.4036971629123407, 9.8881503473657641, 
    0, 9.4036971629123407, 0, 12.573622164354653, 10.808087417991675, 
    10.289108031110409, 0, 0, 0, 0, 0, 12.268767582826236, 0, 
    0, 0, 12.82516093135062, 12.268767582826236, 12.268767582826236, 
    12.936192243739363, 12.429232255019482, 13.343192423952786, 
    12.268767582826236, 11.222332009835949, 6.609457740644995, 
    5.3538188644120552, 12.088195337184413, 0, 0, 9.4036971629123407, 
    9.2866577417221237, 15.615932969212619, 12.704866697632909, 
    9.4036971629123407, 12.936192243739363, 0, 9.4036971629123407, 
    14.448091282270797, 7.6482483901463887, 0, 9.7662672422970509, 
    9.0017553212451809, 10.659352038380538, 9.0059376550653347, 
    8.7376980901002792, 0, 9.4036971629123407, 13.13550105196277, 
    9.7110377215766572, 8.4271561357363289, 0, 12.268767582826236, 
    12.268767582826236, 0, 9.4036971629123407, 0, 0, 0, 6.8766776606457345, 
    9.4036971629123407, 10.942117077696469, 9.6058025701038048, 
    0, 12.900122989031843, 12.268767582826236, 11.805795606483688, 
    9.4036971629123407, 12.339734104180376, 12.936192243739363, 
    12.088195337184413, 14.247393932033667, 13.039285736703468, 
    12.088195337184413, 12.429232255019482, 12.268767582826236, 
    13.31058775852086, 0, 2.7635472627587294, 0, 9.4036971629123407, 
    13.039285736703468, 9.4036971629123407, 0, 0, 0, 9.4036971629123407, 
    11.420770676271285, 11.042598470744302, 6.5144958013160812, 
    7.455105578278757, 9.4036971629123407, 4.8087740953728924, 
    6.4402230389374555, 0, 8.6723789820193993, 9.5828211012011195, 
    3.7780551705108274, 1.5786067460784916, 9.4036971629123407, 
    3.9307880403575033, 11.474086490803739, 9.4036971629123407, 
    9.4036971629123407, 9.4036971629123407, 3.81962266971856, 
    12.088195337184413, 12.573622164354656, 8.8316432511490746, 
    10.449793577501797, 10.862026225102481, 8.5223416594109604, 
    9.4036971629123407, 11.025653871115701, 3.0128723875200096, 
    12.268767582826236, 5.4788917020481041, 12.429232255019482, 
    9.4614126607686302, 4.146158405548821, 6.6174810079128878, 
    12.088195337184413, 12.088195337184413, 14.289829198354063, 
    10.56596859181122, 11.550538551241612, 9.7662672422970509, 
    12.573622164354656, 12.088195337184413, 10.376320723981037, 
    10.966800229669758, 5.7241232326344722, 4.3908236380826864, 
    9.4036971629123407, 9.4036971629123407, 9.4036971629123407, 
    12.429232255019482, 9.3903387800573235, 8.2408418685532574, 
    11.640736360213189, 12.088195337184413, 13.13550105196277, 
    12.82516093135062, 12.163157394865632, 10.800214574220387, 
    11.913108630626322, 12.088195337184413, 10.55476313710334, 
    8.3498104659328725, 10.988659663633499, 11.640736360213189, 
    9.2006700664428251, 9.1181109150886996, 9.1513515194742645, 
    10.002334600530574, 8.450491374391282, 10.271907290356801, 
    11.921545467774962, 12.900122989031839, 8.5663296717882993, 
    12.704866697632909, 7.6262887772352697, 7.3729825415464942, 
    8.8544944253087863, 8.9416343288076092, 8.3393793163890493, 
    9.4252303244619817, 9.2653690063643666, 8.5574532274611421, 
    9.4036971629123407, 7.7425853232653896, 10.709683713930684, 
    9.9727181197644761, 9.053297129199823, 9.6364993673267207, 
    12.268767582826236, 10.683805082105078, 12.268767582826236, 
    8.5749685900621699, 7.3986261733649208, 9.4036971629123407, 
    12.088195337184413, 9.4036971629123407, 9.4036971629123407, 
    11.351229743018205, 12.704866697632909, 12.088195337184413, 
    11.640736360213189, 8.1114832920783222, 8.3986991471123709, 
    12.429232255019482, 12.268767582826236, 12.82516093135062, 
    12.573622164354656, 11.74201969605037, 10.56596859181122, 
    12.268767582826236, 9.3435761704747708, 9.4036971629123407, 
    11.550538551241612, 12.088195337184413, 12.088195337184413, 
    11.550538551241612, 11.587297101251728, 11.413965498366167, 
    13.538856746193979, 11.164816618787325, 11.842034749915015, 
    12.936192243739363, 12.199226649573156, 5.324318186764625, 
    11.725625257799702, 9.4036971629123407, 13.607569496277993, 
    12.268767582826236, 11.413965498366167, 12.900122989031839, 
    8.2797084456368886, 5.2190612861238694, 8.3487614874274563, 
    13.85373008354739, 4.8822721375047013, 4.9115454254922817, 
    9.4036971629123407, 13.31058775852086, 12.429232255019482, 
    12.704866697632909, 12.704866697632905, 12.268767582826236, 
    12.573622164354656, 11.790113984251416, 11.373554289689661, 
    10.784645771611906, 10.851658733527694, 12.126163187383433, 
    9.4036971629123407, 9.84122929997827, 9.4036971629123407, 
    4.1048339157158278, 8.4913912238187415, 8.8461205499862636, 
    9.4036971629123407, 3.5339048690925661, 4.31271500748778, 
    12.82516093135062, 13.039285736703468, 12.268767582826236, 
    8.2305272571520689, 9.4036971629123407, 10.541200686662277, 
    11.881744459716984, 12.704866697632909, 12.429232255019482, 
    13.111165859834051, 12.900122989031839, 12.088195337184413, 
    12.088195337184413, 14.014194755740636, 14.158584665075811, 
    13.153997395580156, 13.082842102690208, 14.063947790937736, 
    13.31058775852086, 14.014194755740636, 12.82516093135062, 
    12.936192243739363, 12.573622164354656, 9.4036971629123407, 
    7.6404108790971144, 9.0411270835276341, 12.82516093135062, 
    8.2562667992571157, 9.4036971629123407, 3.073072450839609, 
    5.417628493763698, 4.7966744755817601, 5.0140483097562019, 
    1.99381617809461, 9.4036971629123407, 13.416521203269925, 
    13.225698860934347, 12.292813056792884, 13.538856746193979, 
    13.416521203269925, 12.429232255019482, 9.4036971629123407, 
    7.6908291077100266, 8.762646926618352, 8.8391987647509005, 
    7.2280989530548343, 2.4932117962486195, 12.429232255019482, 
    15.475925490467521, 12.316464324857529, 6.4453774310391649, 
    12.936192243739363, 9.4036971629123407, 12.429232255019482, 
    12.704866697632909, 4.9743006352770278, 12.82516093135062, 
    12.268767582826236, 9.4036971629123407, 12.704866697632909, 
    12.429232255019482, 12.786166799734755, 7.0608243656682719, 
    12.088195337184413, 9.4036971629123407, 9.4036971629123407, 
    4.2277129545755665, 12.429232255019482, 9.4036971629123407, 
    5.4690641849086781, 9.5403858348807233, 12.82516093135062, 
    10.879381322348504, 13.31058775852086, 12.662431431312509, 
    12.429232255019482, 3.3642087498504418, 13.390758107204846, 
    7.4088836096276776, 5.542648560758523, 9.4036971629123407, 
    12.268767582826236, 11.396317632546744, 12.022606995556835, 
    9.4036971629123407, 6.0740334192453735, 12.268767582826236, 
    13.225698860934347, 13.13550105196277, 12.088195337184413, 
    2.4021958373015844, 12.74608936035942, 11.113286318147242, 
    4.1219472380059088, 8.3294033805650276, 12.429232255019482, 
    8.9103434199704701, 13.629765242392187, 13.718245727434105, 
    12.82516093135062, 12.704866697632909, 9.4036971629123407, 
    11.725625257799702, 10.067783877161451, 13.796014585691104, 
    11.687657407600684, 13.890962989746363, 11.133049572968673, 
    10.58340318514724, 11.396317632546744, 12.429232255019482, 
    12.268767582826236, 13.466706960438144, 12.268767582826236, 
    12.429232255019482, 9.574786097488289, 7.4277681679154206, 
    12.936192243739363, 9.4036971629123407, 9.4036971629123407, 
    13.466706960438144, 12.429232255019482, 9.4036971629123407, 
    7.6004583493269688, 4.8071153408087319, 9.4036971629123407, 
    8.043142302518369, 9.3188082653258277, 9.4036971629123407, 
    9.4036971629123407, 9.2834029291946294, 7.7374345600893371, 
    14.112042079138782, 12.268767582826236, 13.607569496277993, 
    12.82516093135062, 12.429232255019482, 5.0772611337712839, 
    4.7844464046238748, 12.573622164354656, 12.671763255833817, 
    10.473331350749394, 9.4036971629123407, 13.31058775852086, 
    3.6863327968260373, 14.112042079138782, 9.4036971629123407, 
    9.4036971629123407, 9.5884801230817676, 2.9462501553687446, 
    3.9954381962645598, 12.704866697632909, 12.704866697632909, 
    12.429232255019482, 14.55634417292282, 14.289829198354063, 
    12.704866697632909, 12.704866697632909, 13.13550105196277, 
    13.390758107204842, 12.573622164354656, 4.7803134756929122, 
    12.429232255019482, 12.936192243739363, 12.268767582826236, 
    4.7154895061477422, 3.6165920525446333, 6.5819151702194576, 
    7.3093123539519649, 10.022182236230673, 9.0778001658220333, 
    12.429232255019482, 12.704866697632909, 6.180460319520245, 
    9.4036971629123407, 12.268767582826236, 12.009123766193213, 
    12.573622164354656, 12.429232255019482, 5.1370358942221106, 
    9.2432324907190946, 6.2846824814212017, 6.2365687604380851, 
    5.8298683417792718, 3.1471135999683555, 3.5677355005055693, 
    15.100167978850489, 13.13550105196277, 11.943805427849238, 
    14.247393932033667, 4.8273477924958925, 9.4036971629123407, 
    8.1584043394658146, 6.1154909324090934, 9.4036971629123407, 
    12.429232255019482, 7.0093856900014933, 12.82516093135062, 
    6.2288619941529673, 12.82516093135062, 6.2561027225374897, 
    3.2782358569197827, 9.4036971629123407, 9.4036971629123407, 
    5.2264913410385052, 9.4036971629123407, 11.281568865049323, 
    12.268767582826236, 6.8145224109042717, 9.8772985546857939, 
    8.7529212170493125, 11.285641401390627, 11.640736360213191, 
    13.138014458593057, 5.8238816353309932, 8.7089340672310982, 
    13.225698860934347, 11.373172295898884, 11.829593177665879, 
    9.9655760505204576, 9.4036971629123407, 12.666171407589463, 
    4.7186483212809742, 3.4535746538455743, 12.429232255019482, 
    9.1129794690117034, 13.390758107204846, 11.569034894859001, 
    5.6717201980526477, 8.4500078974963806, 4.1175421190165666, 
    2.0935303490026298, 4.1806772555025482, 2.1651994409701549, 
    6.5788335909999951, 14.624248237424624, 12.429232255019482, 
    12.429232255019482, 9.9031181105095527, 13.039285736703468, 
    13.962664455100555, 12.704866697632909, 13.390758107204846, 
    12.268767582826236, 8.6683221918850908, 15.361213831590829, 
    10.208785477998003, 4.8785836610392277, 9.4036971629123407, 
    13.039285736703468, 8.166118337761219, 2.6494297989131965, 
    9.1626890634085463, 2.0820607160015703, 5.5240754276373298, 
    12.936192243739363, 9.4036971629123407, 12.704866697632909, 
    13.039285736703468, 4.1884388546717526, 3.1752856395795073, 
    6.9163007858923304, 9.7662672422970509, 3.8796521864341567, 
    12.429232255019482, 13.890962989746363, 4.3792202273771403, 
    2.1376863805852282, 12.573622164354656, 12.573622164354656, 
    11.396317632546744, 9.4036971629123407, 6.3230879927030657, 
    2.9788237046458876, 12.429232255019482, 10.238335686612272, 
    7.2384764948282001, 7.4258428037922988, 5.6515291621024639, 
    2.7093169510715032, 13.607569496277993, 4.8125295126644776, 
    4.5290808867761267, 12.268767582826236, 8.3166565944707784, 
    6.6353363724706007, 14.867805268759113, 9.4036971629123407, 
    4.1581590056399724, 12.268767582826236, 14.331051861080578, 
    8.4861593231043138, 9.4036971629123407, 13.039285736703468, 
    11.328311150785057, 4.4168079182333049, 12.573622164354656, 
    11.881744459716984, 10.871620242443278, 12.936192243739363, 
    14.590695677713597, 13.481428466144905, 9.4036971629123407, 
    13.909225196139094, 13.796014585691104, 9.6640868474905712, 
    9.8521673157026974, 12.429232255019482, 1.679273702503477, 
    12.936192243739363, 13.962664455100555, 2.060755288335117, 
    12.429232255019482, 12.268767582826236, 9.4036971629123407, 
    3.6321460844753783, 3.9117873746995686, 4.6180478413835075, 
    8.6414019634733883, 3.6353641296839214, 5.7285574362438103, 
    12.429232255019482, 6.1488832638835156, 3.501668890106671, 
    5.6426650411328536, 6.110915413684495, 4.7070585887097796, 
    5.5793852508477952, 4.3248483675888831, 9.4036971629123407, 
    4.7207180427801045, 2.6671081242182035, 9.4036971629123407, 
    1.9598929443421937, 4.5665377281935386, 6.443790698423463, 
    13.466706960438144, 12.268767582826236, 5.5635760743443576, 
    13.390758107204846, 12.429232255019482, 4.4517454193584491, 
    15.494187696860251, 3.6583846251650534, 3.2841431981335631
    ), SM = c(17.480923715934829, 25.735597992713796, 17.480923715934829, 
    68.969413763806287, 17.480923715934829, 34.898871880820479, 
    158.50323124702888, 25.735597992713796, 17.480923715934829, 
    17.480923715934829, 810.32789935797041, 17.480923715934829, 
    17.480923715934829, 17.480923715934829, 111.45029736618521, 
    17.480923715934829, 17.480923715934829, 17.480923715934829, 
    17.480923715934829, 68.969413763806287, 68.969413763806287, 
    17.480923715934829, 17.480923715934829, 69.124312880466846, 
    17.480923715934829, 68.969413763806287, 170.9235344095157, 
    169.5016773200667, 111.45029736618521, 94.457943925233636, 
    467.46491904776553, 174.31973497473527, 232.10245491218808, 
    77.465590484282075, 17.480923715934829, 149.55571214439837, 
    68.969413763806287, 17.480923715934829, 806.32989182499114, 
    60.473237043330499, 145.43500424808835, 60.473237043330499, 
    230.64256760942052, 145.43500424808835, 68.969413763806287, 
    468.28971962616822, 156.52315402505516, 17.480923715934829, 
    68.969413763806287, 355.49491718401941, 168.22878183032952, 
    239.35735635468313, 207.33843208185115, 230.39677145284622, 
    68.969413763806287, 1063.5683413336601, 60.473237043330499, 
    60.473237043330499, 383.90686091247738, 233.71385092611916, 
    94.457943925233636, 17.480923715934829, 17.480923715934829, 
    683.42092665058783, 17.480923715934829, 157.81038642117736, 
    25.735597992713796, 17.480923715934829, 17.480923715934829, 
    11.131608118723097, 19.370678354749611, 17.480923715934829, 
    17.480923715934829, 25.735597992713796, 17.480923715934829, 
    79.41395720236811, 162.42735768903995, 17.480923715934829, 
    17.480923715934829, 17.480923715934829, 386.4524821812185, 
    60.473237043330499, 356.10794392486218, 60.473237043330499, 
    17.480923715934829, 17.480923715934829, 163.02528072915871, 
    166.06506069795628, 25.735597992713796, 77.465590484282075, 
    862.62888057147268, 25.735597992713796, 25.735597992713796, 
    25.735597992713796, 251.89555550632772, 25.735597992713796, 
    657.17603057817735, 111.45029736618521, 17.480923715934829, 
    25.339203148958504, 17.480923715934829, 17.480923715934829, 
    60.473237043330499, 60.473237043330499, 60.473237043330499, 
    163.11670392205599, 17.480923715934829, 17.480923715934829, 
    166.9138064803046, 17.480923715934829, 25.735597992713796, 
    17.480923715934829, 17.480923715934829, 25.735597992713796, 
    607.80823497074073, 17.480923715934829, 25.735597992713796, 
    17.480923715934829, 256.86647774252498, 358.81902908926099, 
    374.40876994721526, 17.480923715934829, 17.480923715934829, 
    17.480923715934829, 17.480923715934829, 17.480923715934829, 
    68.969413763806287, 17.480923715934829, 17.480923715934829, 
    17.480923715934829, 102.95412064570942, 68.969413763806287, 
    68.969413763806287, 111.45029736618521, 77.465590484282075, 
    715.3051529715126, 68.969413763806287, 383.90686091247738, 
    88.294574178798939, 38.731938666098131, 60.473237043330499, 
    17.480923715934829, 17.480923715934829, 25.735597992713796, 
    203.23243877198894, 731.67119796091765, 94.457943925233636, 
    25.735597992713796, 111.45029736618521, 17.480923715934829, 
    25.735597992713796, 323.8547153780799, 176.68709573361826, 
    17.480923715934829, 445.45730010317351, 208.82515550166801, 
    149.32150722798858, 282.43548516940228, 295.50946093140738, 
    17.480923715934829, 25.735597992713796, 128.44265080713677, 
    428.66623508374045, 250.81994309477946, 17.480923715934829, 
    68.969413763806287, 68.969413763806287, 17.480923715934829, 
    25.735597992713796, 17.480923715934829, 17.480923715934829, 
    17.480923715934829, 99.075295630479062, 25.735597992713796, 
    229.07734450378274, 168.9250867835149, 17.480923715934829, 
    898.41153391176829, 68.969413763806287, 149.55571214439837, 
    25.735597992713796, 485.17910572589938, 111.45029736618521, 
    60.473237043330499, 281.37383177570092, 119.946474086661, 
    60.473237043330499, 77.465590484282075, 68.969413763806287, 
    145.43500424808835, 17.480923715934829, 6.7736533016699125, 
    17.480923715934829, 25.735597992713796, 119.946474086661, 
    25.735597992713796, 17.480923715934829, 17.480923715934829, 
    17.480923715934829, 25.735597992713796, 320.35018851396256, 
    381.63628885729952, 83.023228026236254, 152.03443925211261, 
    25.735597992713796, 27.564909156959594, 77.562242225692117, 
    17.480923715934829, 380.83592228438988, 380.90955736696787, 
    13.634666764849143, 2.9839975298761923, 25.735597992713796, 
    15.035573197942687, 193.5812424223364, 25.735597992713796, 
    25.735597992713796, 25.735597992713796, 14.022916096615951, 
    60.473237043330499, 85.961767204757848, 314.17516470906685, 
    193.58286081723782, 372.58859409651427, 244.3008664071528, 
    25.735597992713796, 289.93809847691278, 8.0478396104481806, 
    68.969413763806287, 42.914487352556989, 77.465590484282075, 
    165.10156539322924, 17.534714224823642, 90.461684172762077, 
    60.473237043330499, 60.473237043330499, 289.87000849617669, 
    175.8348521645112, 124.79168931406144, 172.92990149134229, 
    85.961767204757848, 60.473237043330499, 289.9812170065556, 
    437.93870950138302, 49.203131877419253, 20.685479701585695, 
    25.735597992713796, 25.735597992713796, 25.735597992713796, 
    77.465590484282075, 387.96667915742381, 279.06935287729777, 
    217.66080752460607, 60.473237043330499, 128.44265080713677, 
    102.95412064570942, 313.97906793368475, 164.94279087905417, 
    360.20883651737444, 60.473237043330499, 208.40674353411092, 
    203.25464273136683, 718.58722746724766, 133.04636359084043, 
    206.57357692214978, 187.91333138615968, 294.28165738331597, 
    184.18118474155941, 220.8973729541018, 351.56863319529651, 
    541.94410466375484, 322.90387195675675, 210.11120643317179, 
    94.457943925233636, 180.87550406567249, 139.96225256000236, 
    162.05065078779344, 205.23589182222784, 308.994802572482, 
    148.74906507967478, 164.23973924599747, 152.95927023769778, 
    25.735597992713796, 182.14479668671876, 268.26725726624198, 
    159.85512884789625, 232.19401272709075, 248.69878046293445, 
    68.969413763806287, 191.04699283287448, 68.969413763806287, 
    162.51127072277771, 156.23875133872141, 25.735597992713796, 
    60.473237043330499, 25.735597992713796, 25.735597992713796, 
    243.04920913438229, 94.457943925233636, 60.473237043330499, 
    133.04636359084043, 179.64915393163605, 323.94928208769426, 
    77.465590484282075, 68.969413763806287, 102.95412064570942, 
    85.961767204757848, 233.71385092611916, 175.8348521645112, 
    68.969413763806287, 151.95533262564072, 25.735597992713796, 
    124.79168931406144, 60.473237043330499, 60.473237043330499, 
    124.79168931406144, 209.6342858238495, 185.55472072157986, 
    170.9235344095157, 319.58586391065893, 737.48206678872509, 
    111.45029736618521, 322.00558963444126, 39.735679285407322, 
    141.30103786761939, 25.735597992713796, 179.41971112999147, 
    68.969413763806287, 185.55472072157986, 322.90387195675675, 
    171.99074668373163, 36.447043710511949, 158.48639647920481, 
    213.40441801189462, 28.576672195624145, 29.951405445171964, 
    25.735597992713796, 145.43500424808835, 77.465590484282075, 
    94.457943925233636, 281.63050057286188, 68.969413763806287, 
    85.961767204757848, 241.74037262687574, 1214.835974019152, 
    282.72220772202138, 697.42147804558726, 1527.0022840348547, 
    25.735597992713796, 245.989533837327, 25.735597992713796, 
    17.058995275515365, 303.69112570184041, 172.14855323622197, 
    25.735597992713796, 11.51565227654309, 19.512040325626874, 
    102.95412064570942, 119.946474086661, 68.969413763806287, 
    261.75372435825119, 25.735597992713796, 268.80480079116234, 
    257.79341602838883, 94.457943925233636, 77.465590484282075, 
    2530.4955884322017, 322.90387195675675, 60.473237043330499, 
    60.473237043330499, 238.892948173322, 264.38147833474937, 
    627.01341426319038, 1020.1086592586747, 247.38912489379777, 
    145.43500424808835, 238.892948173322, 102.95412064570942, 
    111.45029736618521, 85.961767204757848, 25.735597992713796, 
    170.54931398820364, 148.44832380880538, 102.95412064570942, 
    159.59314232654563, 25.735597992713796, 8.3737100696204845, 
    42.254377744441385, 27.372418748883707, 31.779991169647811, 
    3.9802133822462737, 25.735597992713796, 463.23333466199927, 
    136.93882752761257, 469.55782207483372, 170.9235344095157, 
    463.23333466199927, 77.465590484282075, 25.735597992713796, 
    158.97415341378948, 287.32272020031883, 304.57409036116246, 
    119.65195946418999, 5.612920843509837, 77.465590484282075, 
    663.70178419711124, 477.36846390036658, 75.691940844825922, 
    111.45029736618521, 25.735597992713796, 77.465590484282075, 
    94.457943925233636, 30.419273931370164, 102.95412064570942, 
    68.969413763806287, 25.735597992713796, 94.457943925233636, 
    77.465590484282075, 298.13984912641985, 110.76862143656355, 
    60.473237043330499, 25.735597992713796, 25.735597992713796, 
    18.497455849108082, 77.465590484282075, 25.735597992713796, 
    44.016794593531493, 187.15782214522758, 102.95412064570942, 
    772.56272498354929, 145.43500424808835, 273.37582629608295, 
    77.465590484282075, 10.226089682548201, 153.93118096856415, 
    142.50202828723255, 43.929560519908492, 25.735597992713796, 
    68.969413763806287, 250.85985095991509, 174.31973497473527, 
    25.735597992713796, 62.647620740583569, 68.969413763806287, 
    136.93882752761257, 128.44265080713677, 60.473237043330499, 
    5.2785062006758476, 289.88517484964092, 485.01609347700997, 
    17.152946494387763, 199.02106595104959, 77.465590484282075, 
    248.76418098550673, 537.52540315300996, 1266.2432882791804, 
    102.95412064570942, 94.457943925233636, 25.735597992713796, 
    141.30103786761939, 852.77301790416811, 204.90824129141885, 
    460.41274972095306, 644.8361687511366, 491.74143404495658, 
    141.51086540245578, 250.85985095991509, 77.465590484282075, 
    68.969413763806287, 162.42735768903995, 68.969413763806287, 
    77.465590484282075, 354.46467290311307, 150.12275573405515, 
    111.45029736618521, 25.735597992713796, 25.735597992713796, 
    162.42735768903995, 77.465590484282075, 25.735597992713796, 
    139.27643034040057, 27.128736186059456, 25.735597992713796, 
    201.03389617320821, 170.52818498379207, 25.735597992713796, 
    25.735597992713796, 326.86572827583126, 162.49744882534847, 
    255.88530161427354, 68.969413763806287, 179.41971112999147, 
    102.95412064570942, 77.465590484282075, 32.548440376673263, 
    26.897757757345392, 85.961767204757848, 1659.0852501789363, 
    519.41067679790797, 25.735597992713796, 145.43500424808835, 
    12.764984473449642, 255.88530161427354, 25.735597992713796, 
    25.735597992713796, 193.58545283533113, 7.679583616929949, 
    15.691050835730687, 94.457943925233636, 94.457943925233636, 
    77.465590484282075, 349.34324553950728, 289.87000849617669, 
    94.457943925233636, 94.457943925233636, 128.44265080713677, 
    454.97866038522028, 85.961767204757848, 26.657582947079185, 
    77.465590484282075, 111.45029736618521, 68.969413763806287, 
    25.802982454731602, 12.193151648057492, 85.876516596365335, 
    138.92165278880074, 560.00004978902007, 263.79967820813312, 
    77.465590484282075, 94.457943925233636, 69.681940290255653, 
    25.735597992713796, 68.969413763806287, 281.87298113065856, 
    85.961767204757848, 77.465590484282075, 34.323289916337302, 
    276.09927606338215, 72.183373467543845, 67.355774331384467, 
    54.108821504742693, 8.8099489201151808, 11.768159390709215, 
    510.77060322854709, 128.44265080713677, 368.01947834290723, 
    281.37383177570092, 27.805356367424597, 25.735597992713796, 
    185.62573500282261, 66.491636850260491, 25.735597992713796, 
    77.465590484282075, 114.30156483558652, 102.95412064570942, 
    69.71697827486669, 102.95412064570942, 72.916376603600185, 
    9.6397565330530472, 25.735597992713796, 25.735597992713796, 
    36.537428998113505, 25.735597992713796, 816.67348160312031, 
    68.969413763806287, 93.580120986247181, 252.27797957512158, 
    313.64230829176745, 169.5016773200667, 445.58886700407993, 
    3195.1749936908191, 53.914507821217654, 221.75486123928545, 
    136.93882752761257, 796.32738406694386, 586.27616729338945, 
    283.86186339979952, 25.735597992713796, 1652.6576194888328, 
    25.794467221112686, 10.876085534882735, 77.465590484282075, 
    426.42436513771924, 153.93118096856415, 550.88352095650521, 
    48.436221849955984, 227.46180250112852, 17.27514565131332, 
    4.2597273553676382, 17.935030270397377, 4.4787446516263127, 
    88.198986349504878, 366.33559898045883, 77.465590484282075, 
    77.465590484282075, 476.00975020079471, 119.946474086661, 
    230.39677145284622, 94.457943925233636, 153.93118096856415, 
    68.969413763806287, 322.32543949402219, 612.7247238742566, 
    188.76502975945513, 28.919318411011421, 25.735597992713796, 
    119.946474086661, 211.58081853729414, 6.2572852278360171, 
    208.14990643150139, 4.2263463512364225, 44.894835076214861, 
    111.45029736618521, 25.735597992713796, 94.457943925233636, 
    119.946474086661, 18.16145872251116, 8.9789780645018027, 
    110.38899420616909, 155.97331272502512, 14.612612963822679, 
    77.465590484282075, 644.8361687511366, 20.474311222523465, 
    4.3921037566178533, 85.961767204757848, 85.961767204757848, 
    250.85985095991509, 25.735597992713796, 73.349316417740312, 
    7.8653427021612288, 77.465590484282075, 378.60552205102118, 
    144.47500199578047, 150.08619311873238, 48.816072013223057, 
    6.5174282479497716, 179.41971112999147, 27.134975087627694, 
    22.846463571971469, 68.969413763806287, 149.85078422588396, 
    89.898214178159606, 434.30501274426513, 25.735597992713796, 
    17.716020744060419, 68.969413763806287, 298.36618521665253, 
    227.87644402829184, 25.735597992713796, 119.946474086661, 
    1739.7306326807309, 21.164119276682367, 85.961767204757848, 
    257.79341602838883, 260.29033304316664, 111.45029736618521, 
    357.83942225998294, 787.54384827832166, 25.735597992713796, 
    221.90059473237042, 204.90824129141885, 295.5213507448787, 
    812.30768048337382, 77.465590484282075, 3.1986172543616243, 
    111.45029736618521, 230.39677145284622, 4.1635394645773287, 
    77.465590484282075, 68.969413763806287, 25.735597992713796, 
    12.365385952472451, 14.888897223266572, 24.26453562251654, 
    296.85666367747177, 12.359433569472495, 49.383746626304124, 
    77.465590484282075, 66.790962418275157, 11.254644485854033, 
    47.778692773963357, 62.726186925226983, 25.371828240385902, 
    46.568935821341746, 19.855017299426873, 25.735597992713796, 
    25.600282835148409, 6.3238739352273292, 25.735597992713796, 
    3.882758926483604, 23.420222781399985, 80.640873478771695, 
    162.42735768903995, 68.969413763806287, 45.735677627042747, 
    153.93118096856415, 77.465590484282075, 21.388939037025178, 
    672.19796091758701, 12.513387294714381, 9.6858492938885536
    ), LRC = c(0, 0.98836409028735916, 0, 6.0208520251917079, 
    0, 4.3819287137577136, 6.7157338951967249, 0.98836409028735916, 
    0, 0, 10.096281627912186, 0, 0, 0, 7.297356489875896, 0, 
    0, 0, 0, 6.0208520251917079, 6.0208520251917079, 0, 0, 5.3103358891813492, 
    0, 6.0208520251917079, 8.2204241531440481, 7.7302083690049459, 
    7.297356489875896, 6.8936261757752746, 8.9951075958118203, 
    7.9766683750578435, 8.5356949440316736, 6.3619787916911124, 
    0, 7.656575963090841, 6.0208520251917079, 0, 9.9739641681680098, 
    5.602621569093289, 7.8888354264091873, 5.602621569093289, 
    8.0084302410370896, 7.8888354264091873, 6.0208520251917079, 
    10.01596031911636, 7.215605009652208, 0, 6.0208520251917079, 
    8.1762847137912953, 7.4614933030362813, 8.0051839352577829, 
    8.320717794219707, 8.79300007725824, 6.0208520251917079, 
    10.163151124645376, 5.602621569093289, 5.602621569093289, 
    8.8647523930609431, 8.3674462244512391, 6.8936261757752746, 
    0, 0, 9.1322385165958124, 0, 7.7707303121626454, 0.98836409028735916, 
    0, 0, 2.9572647016605624, 3.9764596986572665, 0, 0, 0.98836409028735916, 
    0, 5.7571499505159593, 8.1176332792013195, 0, 0, 0, 8.2982888515446245, 
    5.602621569093289, 8.2317196403432291, 5.602621569093289, 
    0, 0, 7.163260199216106, 7.8771110936003952, 0.98836409028735916, 
    6.3619787916911124, 9.8613412882923335, 0.98836409028735916, 
    0.98836409028735916, 0.98836409028735916, 8.2652840548300919, 
    0.98836409028735916, 9.0194953409496872, 7.297356489875896, 
    0, 4.285452491097268, 0, 0, 5.602621569093289, 5.602621569093289, 
    5.602621569093289, 6.7541088404744904, 0, 0, 6.9708773132425526, 
    0, 0.98836409028735916, 0, 0, 0.98836409028735916, 8.931872981084922, 
    0, 0.98836409028735916, 0, 8.7237552709679616, 8.6295099222499569, 
    8.4839306879296359, 0, 0, 0, 0, 0, 6.0208520251917079, 0, 
    0, 0, 7.1078047330350378, 6.0208520251917079, 6.0208520251917079, 
    7.297356489875896, 6.3619787916911124, 10.280015672332942, 
    6.0208520251917079, 8.8647523930609431, 5.8122741075116267, 
    4.5233071164457357, 5.602621569093289, 0, 0, 0.98836409028735916, 
    7.3030512265750041, 10.727320917577027, 6.8936261757752746, 
    0.98836409028735916, 7.297356489875896, 0, 0.98836409028735916, 
    9.3987275216843855, 6.9587762797560604, 0, 8.5101715318556188, 
    7.2502175472510073, 7.3168377341593143, 7.6970287166977682, 
    7.7288747590916156, 0, 0.98836409028735916, 7.6205232603801534, 
    8.4457373439322438, 7.4485792306430749, 0, 6.0208520251917079, 
    6.0208520251917079, 0, 0.98836409028735916, 0, 0, 0, 5.8783327187118637, 
    0.98836409028735916, 8.0842934438142606, 7.1362011770059652, 
    0, 10.412481431195015, 6.0208520251917079, 7.656575963090841, 
    0.98836409028735916, 9.5238191267781147, 7.297356489875896, 
    5.602621569093289, 9.1535813282574825, 7.4670755589507509, 
    5.602621569093289, 6.3619787916911124, 6.0208520251917079, 
    7.8888354264091873, 0, 2.4033311979010752, 0, 0.98836409028735916, 
    7.4670755589507509, 0.98836409028735916, 0, 0, 0, 0.98836409028735916, 
    8.7059126784272927, 8.7918860492920921, 5.7145648073962265, 
    6.6822482748278453, 0.98836409028735916, 4.289197330907518, 
    5.5457634149126189, 0, 8.2647288740994966, 8.2577226458652842, 
    3.3552422446351748, 1.2708349275194371, 0.98836409028735916, 
    3.3085232128086055, 8.0010312672085373, 0.98836409028735916, 
    0.98836409028735916, 0.98836409028735916, 3.3775064154895929, 
    5.602621569093289, 6.6481840446453484, 7.8333885688152076, 
    7.6617421816259013, 8.6955917030687413, 7.4003732528580608, 
    0.98836409028735916, 8.438251139932575, 2.6471293289443016, 
    6.0208520251917079, 4.8183354674980254, 6.3619787916911124, 
    7.0457399337759812, 3.6665975267545599, 5.907834044169527, 
    5.602621569093289, 5.602621569093289, 9.2059821721416544, 
    7.5543615953434502, 7.2545154076426313, 7.2335661614895059, 
    6.6481840446453484, 5.602621569093289, 8.1986415442378995, 
    8.9267385369165719, 4.8613346854356347, 3.8510546223274478, 
    0.98836409028735916, 0.98836409028735916, 0.98836409028735916, 
    6.3619787916911124, 8.2302353577543759, 7.7638427118515132, 
    8.2312660867113987, 5.602621569093289, 7.6205232603801534, 
    7.1078047330350378, 8.9083520130249667, 7.5314036464528451, 
    9.0178329470712075, 5.602621569093289, 7.8098694514451346, 
    7.0723299106097111, 9.4805148242260859, 7.400063425269285, 
    7.2978281114000429, 7.1264443771659272, 7.7907961841671405, 
    7.4202341594046608, 7.2237802314565194, 8.4010271589678638, 
    9.5192788611578631, 9.1331325565370172, 7.1538362184315707, 
    6.8936261757752746, 7.0570465602269641, 6.5062811282334119, 
    6.8035306850660131, 7.2059025936466021, 7.9846640697124922, 
    6.8606954844437018, 6.9654617936027234, 6.6194374984559632, 
    0.98836409028735916, 6.9707079995510721, 8.2207914947890472, 
    7.1852505899515249, 7.4236669461192255, 7.7163665513298039, 
    6.0208520251917079, 7.7250940447395244, 6.0208520251917079, 
    6.7283777659007216, 6.8406816964891659, 0.98836409028735916, 
    5.602621569093289, 0.98836409028735916, 0.98836409028735916, 
    8.305577419978297, 6.8936261757752746, 5.602621569093289, 
    7.400063425269285, 6.8408946651389648, 8.0717805064334591, 
    6.3619787916911124, 6.0208520251917079, 7.1078047330350378, 
    6.6481840446453484, 8.3674462244512391, 7.5543615953434502, 
    6.0208520251917079, 6.8662656140382321, 0.98836409028735916, 
    7.2545154076426313, 5.602621569093289, 5.602621569093289, 
    7.2545154076426313, 8.1583079763188771, 7.915912834072957, 
    8.2204241531440481, 8.6145292526300796, 9.8320150434411424, 
    7.297356489875896, 8.9530417190630409, 5.0121482880462036, 
    7.5334936031188375, 0.98836409028735916, 8.3167322120993283, 
    6.0208520251917079, 7.915912834072957, 9.1331325565370172, 
    6.7699218305628506, 4.6918728989340392, 6.6348086122305201, 
    8.6503803348065738, 4.167841931569372, 4.640064282612852, 
    0.98836409028735916, 7.8888354264091873, 6.3619787916911124, 
    6.8936261757752746, 8.8907671511623665, 6.0208520251917079, 
    6.6481840446453484, 8.4312009250794162, 10.164283023023867, 
    8.3180985518090633, 9.3971536870191041, 10.672729139712846, 
    0.98836409028735916, 7.7772490203631195, 0.98836409028735916, 
    3.6493128088454037, 7.8134812679843328, 6.9002257820129529, 
    0.98836409028735916, 3.0933766411663837, 3.6771965249032399, 
    7.1078047330350378, 7.4670755589507509, 6.0208520251917079, 
    7.5954102746392227, 0.98836409028735916, 8.1611274883162839, 
    8.5511472703483307, 6.8936261757752746, 6.3619787916911124, 
    11.530551300033963, 9.1331325565370172, 5.602621569093289, 
    5.602621569093289, 8.8595072807403721, 9.0428517426433235, 
    10.069957879854464, 10.61005971500062, 8.9231703223559435, 
    7.8888354264091873, 8.8595072807403721, 7.1078047330350378, 
    7.297356489875896, 6.6481840446453484, 0.98836409028735916, 
    6.8635503556610384, 6.7183354870918448, 7.1078047330350378, 
    6.6321282038546281, 0.98836409028735916, 2.6109022147641423, 
    5.0597026522470863, 4.2981989439026727, 4.5260202316745533, 
    1.739272155584799, 0.98836409028735916, 9.7457781187449033, 
    7.7604087499168877, 9.4693184583361152, 8.2204241531440481, 
    9.7457781187449033, 6.3619787916911124, 0.98836409028735916, 
    6.6581483056222632, 7.6845171324464108, 7.7842440902920949, 
    6.1618792483134133, 2.0708124350921602, 6.3619787916911124, 
    10.574436492315037, 9.4968223521370838, 5.430435538790837, 
    7.297356489875896, 0.98836409028735916, 6.3619787916911124, 
    6.8936261757752746, 4.2647099266344259, 7.1078047330350378, 
    6.0208520251917079, 0.98836409028735916, 6.8936261757752746, 
    6.3619787916911124, 8.9925197804937902, 6.062168107062841, 
    5.602621569093289, 0.98836409028735916, 0.98836409028735916, 
    3.6880733889121742, 6.3619787916911124, 0.98836409028735916, 
    5.2075459802151762, 7.2710020735146612, 7.1078047330350378, 
    9.516115372448251, 7.8888354264091873, 8.837151159377612, 
    6.3619787916911124, 2.8595516104153491, 8.0074655512579689, 
    6.5302779065308352, 4.7213380447911879, 0.98836409028735916, 
    6.0208520251917079, 8.3651638901190033, 7.9766683750578435, 
    0.98836409028735916, 5.2943346300851095, 6.0208520251917079, 
    7.7604087499168877, 7.6205232603801534, 5.602621569093289, 
    2.0942458857449791, 8.9425156132092543, 9.0994125204563723, 
    3.5177100074447138, 7.0338727175984861, 6.3619787916911124, 
    7.48761598380836, 9.9893109196520324, 11.041688355757312, 
    7.1078047330350378, 6.8936261757752746, 0.98836409028735916, 
    7.5334936031188375, 9.4205910467974139, 8.573633619574677, 
    9.2478556642593386, 10.281773673673698, 9.1225078469703114, 
    7.1976997786195813, 8.3651638901190033, 6.3619787916911124, 
    6.0208520251917079, 8.1176332792013195, 6.0208520251917079, 
    6.3619787916911124, 8.1627561888383582, 6.6688979006173152, 
    7.297356489875896, 0.98836409028735916, 0.98836409028735916, 
    8.1176332792013195, 6.3619787916911124, 0.98836409028735916, 
    6.3788451094604071, 4.0768794217826994, 0.98836409028735916, 
    7.0732250033904807, 7.0450000199691099, 0.98836409028735916, 
    0.98836409028735916, 7.9708706821423005, 6.6925710535540928, 
    8.9842176741107771, 6.0208520251917079, 8.3167322120993283, 
    7.1078047330350378, 6.3619787916911124, 4.3488856980509834, 
    4.1450316951247439, 6.6481840446453484, 10.961829942233789, 
    8.933402694301229, 0.98836409028735916, 7.8888354264091873, 
    3.1760142125764341, 8.9842176741107771, 0.98836409028735916, 
    0.98836409028735916, 7.339880781027043, 2.5377425363679444, 
    3.3376824342504863, 6.8936261757752746, 6.8936261757752746, 
    6.3619787916911124, 9.5283222548280655, 9.2059821721416544, 
    6.8936261757752746, 6.8936261757752746, 7.6205232603801534, 
    9.7160275022651046, 6.6481840446453484, 4.057533699876803, 
    6.3619787916911124, 7.297356489875896, 6.0208520251917079, 
    4.1578753034897584, 3.1806256202378651, 5.7400202321987646, 
    6.5419200741504682, 8.86539377968864, 7.6158693743059143, 
    6.3619787916911124, 6.8936261757752746, 5.6341283877719706, 
    0.98836409028735916, 6.0208520251917079, 8.7148020157353887, 
    6.6481840446453484, 6.3619787916911124, 4.5558765922685556, 
    7.7272139367353878, 5.5291455953044197, 5.2850765058766873, 
    5.1464287982313639, 2.6702610318753512, 3.0694153868998502, 
    10.156939248835698, 7.6205232603801534, 9.0550951686334304, 
    9.1535813282574825, 4.2458510957578248, 0.98836409028735916, 
    6.902133519527891, 5.5452463884025756, 0.98836409028735916, 
    6.3619787916911124, 6.2244755038903472, 7.1078047330350378, 
    5.4825558513825712, 7.1078047330350378, 5.6732303449553187, 
    2.7826232568433764, 0.98836409028735916, 0.98836409028735916, 
    4.6672262861355032, 0.98836409028735916, 9.7257662773251674, 
    6.0208520251917079, 5.7493977658750097, 7.825181677423708, 
    7.8289906049853109, 7.7302083690049459, 9.1926214772201451, 
    11.757506576959464, 5.1433257247007527, 7.2669042060895759, 
    7.7604087499168877, 9.7348200561514648, 9.5765848712531429, 
    8.0152325627116063, 0.98836409028735916, 10.955958598527165, 
    4.1216534258691855, 2.9497140497123389, 6.3619787916911124, 
    8.3359371837695253, 8.0074655512579689, 9.4126988111849226, 
    4.9453364084746116, 7.2742711656009567, 3.7771912052470746, 
    1.7222505900205267, 3.6730595030033211, 1.839011898480537, 
    5.8683550507963638, 9.608762051735809, 6.3619787916911124, 
    6.3619787916911124, 8.6334848597245379, 7.4670755589507509, 
    8.79300007725824, 6.8936261757752746, 8.0074655512579689, 
    6.0208520251917079, 7.8855393494825181, 10.448162857539643, 
    7.5349479912016326, 4.3632215954930178, 0.98836409028735916, 
    7.4670755589507509, 7.1534617927396296, 2.2666823899537647, 
    7.2964693972422294, 1.7169150231701162, 5.0100961686537788, 
    7.297356489875896, 0.98836409028735916, 6.8936261757752746, 
    7.4670755589507509, 3.8860389857383311, 2.6801388185147781, 
    6.2288846260881616, 7.0675416562544875, 3.4319841932943609, 
    6.3619787916911124, 10.281773673673698, 3.794227354741786, 
    1.7694289180170253, 6.6481840446453484, 6.6481840446453484, 
    8.3651638901190033, 0.98836409028735916, 5.5205579431619194, 
    2.6498836973924349, 6.3619787916911124, 8.4781796805027572, 
    6.805292678369641, 6.6699838735959043, 5.1101282352261332, 
    2.284826777770768, 8.3167322120993283, 4.0398529941595704, 
    4.083110876199374, 6.0208520251917079, 6.5280855142278593, 
    5.8443688599844954, 9.8924401329336469, 0.98836409028735916, 
    3.732116020231937, 6.0208520251917079, 9.2565851609922056, 
    7.2795146624790545, 0.98836409028735916, 7.4670755589507509, 
    10.530981797375565, 3.9863905075195718, 6.6481840446453484, 
    8.5511472703483307, 8.2385254549373741, 7.297356489875896, 
    9.5690943593931159, 10.43180852483356, 0.98836409028735916, 
    8.7233895762301366, 8.573633619574677, 7.9572553237985248, 
    9.3659247665353487, 6.3619787916911124, 1.3413204908650582, 
    7.297356489875896, 8.79300007725824, 1.6769134216842778, 
    6.3619787916911124, 6.0208520251917079, 0.98836409028735916, 
    3.3334194183006276, 3.3687555944602519, 4.1541460894402711, 
    7.7378773373963661, 3.2212770450915222, 4.8709811456175931, 
    6.3619787916911124, 5.4598221315035786, 3.0355996914675569, 
    4.9620417666667374, 5.2040059058386259, 3.9854991676790199, 
    5.0555632476351482, 3.8799045327575885, 0.98836409028735916, 
    3.9954680892427947, 2.1887065582914813, 0.98836409028735916, 
    1.5762117662296413, 4.1012755881108207, 5.7255453594305568, 
    8.1176332792013195, 6.0208520251917079, 4.9662140211790948, 
    8.0074655512579689, 6.3619787916911124, 3.7660717329164513, 
    10.594452767472202, 3.1276370641440576, 2.8161024007740902
    ), LRC.positive = c(-1.9175542964879597, 1.3249081643100369, 
    -1.9175542964879597, 6.1753469435937509, -1.9175542964879597, 
    4.4080370749805997, 6.7761543277855303, 1.3249081643100369, 
    -1.9175542964879597, -1.9175542964879597, 10.150013096260897, 
    -1.9175542964879597, -1.9175542964879597, -1.9175542964879597, 
    7.4177235841755396, -1.9175542964879597, -1.9175542964879597, 
    -1.9175542964879597, -1.9175542964879597, 6.1753469435937509, 
    6.1753469435937509, -1.9175542964879597, -1.9175542964879597, 
    5.3416020484839253, -1.9175542964879597, 6.1753469435937509, 
    8.323646737384534, 7.8196577431483707, 7.4177235841755396, 
    7.0234753193211334, 9.0467946125836907, 8.0706371530006784, 
    8.6221934937195499, 6.5061804779596342, -1.9175542964879597, 
    7.7556961867637417, 6.1753469435937509, -1.9175542964879597, 
    10.024172801807063, 5.7708268701122476, 7.9975119382401267, 
    5.7708268701122476, 8.0797977096968072, 7.9975119382401267, 
    6.1753469435937509, 10.100897837390541, 7.2978545191105324, 
    -1.9175542964879597, 6.1753469435937509, 8.2174923830828313, 
    7.5440151120181733, 8.0734959382064417, 8.4098695761988242, 
    8.8885092321283228, 6.1753469435937509, 10.204108316707428, 
    5.7708268701122476, 5.7708268701122476, 8.9251428163965851, 
    8.4483112172810486, 7.0234753193211334, -1.9175542964879597, 
    -1.9175542964879597, 9.144484456381349, -1.9175542964879597, 
    7.8679369570503113, 1.3249081643100369, -1.9175542964879597, 
    -1.9175542964879597, 2.9741368989265866, 3.985986112378316, 
    -1.9175542964879597, -1.9175542964879597, 1.3249081643100369, 
    -1.9175542964879597, 5.7773110672542609, 8.2224653693445529, 
    -1.9175542964879597, -1.9175542964879597, -1.9175542964879597, 
    8.3099105823317405, 5.7708268701122476, 8.2755377620857349, 
    5.7708268701122476, -1.9175542964879597, -1.9175542964879597, 
    7.2397631513688925, 7.9726111178617014, 1.3249081643100369, 
    6.5061804779596342, 9.9041583945969816, 1.3249081643100369, 
    1.3249081643100369, 1.3249081643100369, 8.3373835566260617, 
    1.3249081643100369, 9.0401563155221503, 7.4177235841755396, 
    -1.9175542964879597, 4.2976920752481211, -1.9175542964879597, 
    -1.9175542964879597, 5.7708268701122476, 5.7708268701122476, 
    5.7708268701122476, 6.8122024039311446, -1.9175542964879597, 
    -1.9175542964879597, 7.0376336388939569, -1.9175542964879597, 
    1.3249081643100369, -1.9175542964879597, -1.9175542964879597, 
    1.3249081643100369, 8.9594704832627503, -1.9175542964879597, 
    1.3249081643100369, -1.9175542964879597, 8.8081440669902662, 
    8.6871959251760913, 8.5337591083653823, -1.9175542964879597, 
    -1.9175542964879597, -1.9175542964879597, -1.9175542964879597, 
    -1.9175542964879597, 6.1753469435937509, -1.9175542964879597, 
    -1.9175542964879597, -1.9175542964879597, 7.2324702919656225, 
    6.1753469435937509, 6.1753469435937509, 7.4177235841755396, 
    6.5061804779596342, 10.346649052299547, 6.1753469435937509, 
    8.9251428163965851, 5.8374357896515283, 4.5500118848355529, 
    5.7708268701122476, -1.9175542964879597, -1.9175542964879597, 
    1.3249081643100369, 7.3615157989440396, 10.808766032718912, 
    7.0234753193211334, 1.3249081643100369, 7.4177235841755396, 
    -1.9175542964879597, 1.3249081643100369, 9.4881305136998062, 
    6.9800017975256567, -1.9175542964879597, 8.5462253817980098, 
    7.3025437157248083, 7.4066718935270872, 7.7358813199763778, 
    7.759111164983846, -1.9175542964879597, 1.3249081643100369, 
    7.734183656299237, 8.482132875056374, 7.4782225335133026, 
    -1.9175542964879597, 6.1753469435937509, 6.1753469435937509, 
    -1.9175542964879597, 1.3249081643100369, -1.9175542964879597, 
    -1.9175542964879597, -1.9175542964879597, 5.910002740463975, 
    1.3249081643100369, 8.1584388582877949, 7.2080820211198962, 
    -1.9175542964879597, 10.470451766993898, 6.1753469435937509, 
    7.7556961867637417, 1.3249081643100369, 9.5895324809677174, 
    7.4177235841755396, 5.7708268701122476, 9.2452260625575438, 
    7.5838233616810378, 5.7708268701122476, 6.5061804779596342, 
    6.1753469435937509, 7.9975119382401267, -1.9175542964879597, 
    2.4146373447019869, -1.9175542964879597, 1.3249081643100369, 
    7.5838233616810378, 1.3249081643100369, -1.9175542964879597, 
    -1.9175542964879597, -1.9175542964879597, 1.3249081643100369, 
    8.7736955172088766, 8.8504407605522069, 5.7398576481363763, 
    6.7062035780819134, 1.3249081643100369, 4.3056147040180752, 
    5.5742288919891116, -1.9175542964879597, 8.277026545309857, 
    8.2960136466337122, 3.3685553999729065, 1.2804637104243801, 
    1.3249081643100369, 3.3284012735410209, 8.086544084876067, 
    1.3249081643100369, 1.3249081643100369, 1.3249081643100369, 
    3.3914459327899724, 5.7708268701122476, 6.7843982265157035, 
    7.8632076049830495, 7.7374483352918224, 8.7527722244115704, 
    7.4343086412316133, 1.3249081643100369, 8.5050779538670618, 
    2.6586107053563408, 6.1753469435937509, 4.8393137076112724, 
    6.5061804779596342, 7.1167925557159766, 3.6817461446616035, 
    5.9301296896289895, 5.7708268701122476, 5.7708268701122476, 
    9.2971228077488526, 7.635497132304546, 7.361070687398751, 
    7.306396865644099, 6.7843982265157035, 5.7708268701122476, 
    8.2580632345889047, 8.9804670735974828, 4.8890273239779596, 
    3.8681653150508462, 1.3249081643100369, 1.3249081643100369, 
    1.3249081643100369, 6.5061804779596342, 8.2641183899063879, 
    7.7783188325036772, 8.313770535328425, 5.7708268701122476, 
    7.734183656299237, 7.2324702919656225, 8.983655827488457, 
    7.6177556942079496, 9.087059469263945, 5.7708268701122476, 
    7.8836446122580632, 7.111365489486011, 9.521256934055593, 
    7.5038005599927642, 7.3541433334480919, 7.1858427988732876, 
    7.8309130623931003, 7.4930379271862222, 7.2610611946135348, 
    8.4526543294841208, 9.5781504422334773, 9.2135576741096212, 
    7.1967154043172288, 7.0234753193211334, 7.074527923175161, 
    6.5332891821539825, 6.8659205678174908, 7.2579265715159496, 
    7.9954224923248294, 6.9367304412384962, 7.0339327258439397, 
    6.6792828187942268, 1.3249081643100369, 6.9944692236535797, 
    8.2868067476510028, 7.2644546215917076, 7.4720907736225453, 
    7.7715697172230742, 6.1753469435937509, 7.8038089647278275, 
    6.1753469435937509, 6.7851442419494603, 6.8578799303989317, 
    1.3249081643100369, 5.7708268701122476, 1.3249081643100369, 
    1.3249081643100369, 8.3815868351779521, 7.0234753193211334, 
    5.7708268701122476, 7.5038005599927642, 6.8801007117547739, 
    8.0816926658513548, 6.5061804779596342, 6.1753469435937509, 
    7.2324702919656225, 6.7843982265157035, 8.4483112172810486, 
    7.635497132304546, 6.1753469435937509, 6.9399941176961395, 
    1.3249081643100369, 7.361070687398751, 5.7708268701122476, 
    5.7708268701122476, 7.361070687398751, 8.2417330425297965, 
    8.0026156253319733, 8.323646737384534, 8.6797420884194771, 
    9.8827747528275864, 7.4177235841755396, 9.0279493157228021, 
    5.0218572018008318, 7.6347739246382211, 1.3249081643100369, 
    8.4185111895854021, 6.1753469435937509, 8.0026156253319733, 
    9.2135576741096212, 6.8165256663798113, 4.7085018431182073, 
    6.6879173329912902, 8.7476208559524586, 4.1907157734761391, 
    4.6484994614356774, 1.3249081643100369, 7.9975119382401267, 
    6.5061804779596342, 7.0234753193211334, 8.9734387624675414, 
    6.1753469435937509, 6.7843982265157035, 8.5113329289983835, 
    10.197261691700804, 8.3831486086969882, 9.4367763626664249, 
    10.710863928286226, 1.3249081643100369, 7.8358034669490575, 
    1.3249081643100369, 3.663678636380244, 7.8339432909225568, 
    6.9592429565322984, 1.3249081643100369, 3.1072727603871471, 
    3.697489377470875, 7.2324702919656225, 7.5838233616810378, 
    6.1753469435937509, 7.6146949825439316, 1.3249081643100369, 
    8.2251630500528012, 8.6299583252417218, 7.0234753193211334, 
    6.5061804779596342, 11.570773593291671, 9.2135576741096212, 
    5.7708268701122476, 5.7708268701122476, 8.954249611079705, 
    9.1356082861198562, 10.137520781436127, 10.667402211211032, 
    9.0172021093037635, 7.9975119382401267, 8.954249611079705, 
    7.2324702919656225, 7.4177235841755396, 6.7843982265157035, 
    1.3249081643100369, 6.8875279394331725, 6.7887490912537167, 
    7.2324702919656225, 6.6825268693725839, 1.3249081643100369, 
    2.625516215895241, 5.0708601220192016, 4.31392753139958, 
    4.5413918283203101, 1.7472027390315477, 1.3249081643100369, 
    9.8216693628278424, 7.8714056628068239, 9.5353652726789395, 
    8.323646737384534, 9.8216693628278424, 6.5061804779596342, 
    1.3249081643100369, 6.6902412940909644, 7.7168104448684849, 
    7.8157492259336907, 6.1955151241106581, 2.0841370965772104, 
    6.5061804779596342, 10.656510079692948, 9.5626996171999554, 
    5.4629554351092473, 7.4177235841755396, 1.3249081643100369, 
    6.5061804779596342, 7.0234753193211334, 4.2874073624902582, 
    7.2324702919656225, 6.1753469435937509, 1.3249081643100369, 
    7.0234753193211334, 6.5061804779596342, 9.0742139218645796, 
    6.093709828473151, 5.7708268701122476, 1.3249081643100369, 
    1.3249081643100369, 3.7051900600444569, 6.5061804779596342, 
    1.3249081643100369, 5.2156515509855934, 7.3370670246487091, 
    7.2324702919656225, 9.5534163428355239, 7.9975119382401267, 
    8.9203584983780466, 6.5061804779596342, 2.8755530926118178, 
    8.114103067619503, 6.5576449064782452, 4.7476814238708887, 
    1.3249081643100369, 6.1753469435937509, 8.4405124650977328, 
    8.0706371530006784, 1.3249081643100369, 5.3191218724124685, 
    6.1753469435937509, 7.8714056628068239, 7.734183656299237, 
    5.7708268701122476, 2.1038763154761511, 9.0246837653828003, 
    9.1520718740288558, 3.5369738924300855, 7.0735131112970535, 
    6.5061804779596342, 7.5300885025247739, 10.063791477019382, 
    11.101352635066068, 7.2324702919656225, 7.0234753193211334, 
    1.3249081643100369, 7.6347739246382211, 9.4394775610847343, 
    8.671856324109994, 9.308320375945458, 10.354806440969835, 
    9.175031496704328, 7.2895886361492144, 8.4405124650977328, 
    6.5061804779596342, 6.1753469435937509, 8.2224653693445529, 
    6.1753469435937509, 6.5061804779596342, 8.2035299279883382, 
    6.6924230705670009, 7.4177235841755396, 1.3249081643100369, 
    1.3249081643100369, 8.2224653693445529, 6.5061804779596342, 
    1.3249081643100369, 6.4172037001867119, 4.1002965252584955, 
    1.3249081643100369, 7.1029772987134754, 7.1123589466891, 
    1.3249081643100369, 1.3249081643100369, 8.0093312952086659, 
    6.7250088769276211, 9.0775892468360642, 6.1753469435937509, 
    8.4185111895854021, 7.2324702919656225, 6.5061804779596342, 
    4.3721974288276764, 4.1654080402581091, 6.7843982265157035, 
    11.005072123642423, 8.9758484361322051, 1.3249081643100369, 
    7.9975119382401267, 3.1921910595810563, 9.0775892468360642, 
    1.3249081643100369, 1.3249081643100369, 7.4050638108236084, 
    2.550609029250237, 3.3587453715147326, 7.0234753193211334, 
    7.0234753193211334, 6.5061804779596342, 9.6166550616459592, 
    9.2971228077488526, 7.0234753193211334, 7.0234753193211334, 
    7.734183656299237, 9.7921050493457855, 6.7843982265157035, 
    4.0807032969216772, 6.5061804779596342, 7.4177235841755396, 
    6.1753469435937509, 4.1755493037068971, 3.1943709389835244, 
    5.7666687985793033, 6.5657790228735697, 8.8983676414782558, 
    7.6591602965636483, 6.5061804779596342, 7.0234753193211334, 
    5.6512449479071236, 1.3249081643100369, 6.1753469435937509, 
    8.791929190600916, 6.7843982265157035, 6.5061804779596342, 
    4.574283388598424, 7.7717338874866044, 5.5530613345909305, 
    5.3155633191686409, 5.1680924525160838, 2.6853545431046615, 
    3.0852018602351641, 10.241060988816294, 7.734183656299237, 
    9.1240292503229004, 9.2452260625575438, 4.264302402178803, 
    1.3249081643100369, 6.9408066846366667, 5.5631478705158166, 
    1.3249081643100369, 6.5061804779596342, 6.2490505782681618, 
    7.2324702919656225, 5.5061856037427557, 7.2324702919656225, 
    5.6915124628996594, 2.7983296144888734, 1.3249081643100369, 
    1.3249081643100369, 4.684903561940672, 1.3249081643100369, 
    9.7672184541871125, 6.1753469435937509, 5.783353512237376, 
    7.8832458226979245, 7.8566648916080979, 7.8196577431483707, 
    9.2534404260381944, 11.793425356746873, 5.1648955172177491, 
    7.3104031051350482, 7.8714056628068239, 9.7780815331930242, 
    9.6325808859495279, 8.0700778520032461, 1.3249081643100369, 
    10.999211658539213, 4.1406278492653836, 2.9656865185037171, 
    6.5061804779596342, 8.3589947044897634, 8.114103067619503, 
    9.4673261814132985, 4.9684613240396436, 7.3099675944376115, 
    3.7878363471909973, 1.7339200546614379, 3.6891254692365902, 
    1.8492282581535384, 5.8906913388576845, 9.6964681544210247, 
    6.5061804779596342, 6.5061804779596342, 8.6697060999319326, 
    7.5838233616810378, 8.8885092321283228, 7.0234753193211334, 
    8.114103067619503, 6.1753469435937509, 7.9090526494497677, 
    10.530802111093621, 7.6090711632987649, 4.3794954859940622, 
    1.3249081643100369, 7.5838233616810378, 7.1844298067624175, 
    2.278717677995028, 7.3517960373834388, 1.7283863417138738, 
    5.0262617151459166, 7.4177235841755396, 1.3249081643100369, 
    7.0234753193211334, 7.5838233616810378, 3.8954708281997452, 
    2.6958326210138694, 6.2503522285359496, 7.1455138086912102, 
    3.446102538275829, 6.5061804779596342, 10.354806440969835, 
    3.8128332081947685, 1.781000363173719, 6.7843982265157035, 
    6.7843982265157035, 8.4405124650977328, 1.3249081643100369, 
    5.5460143244877473, 2.6601817181646399, 6.5061804779596342, 
    8.5269564911212914, 6.8186306438906898, 6.693414298753348, 
    5.1271686480470722, 2.298216671668337, 8.4185111895854021, 
    4.0647048083007835, 4.0971468356351837, 6.1753469435937509, 
    6.5837660673124843, 5.8693150866522519, 9.9781500473063041, 
    1.3249081643100369, 3.7455215694176553, 6.1753469435937509, 
    9.3472520861623973, 7.3161166726248945, 1.3249081643100369, 
    7.5838233616810378, 10.553522868913445, 3.9999273889612108, 
    6.7843982265157035, 8.6299583252417218, 8.3073517964926786, 
    7.4177235841755396, 9.6571060018220596, 10.497839867213498, 
    1.3249081643100369, 8.8197287607597978, 8.671856324109994, 
    8.0062111133301261, 9.3802977923307935, 6.5061804779596342, 
    1.3519175523138107, 7.4177235841755396, 8.8885092321283228, 
    1.6889897025334164, 6.5061804779596342, 6.1753469435937509, 
    1.3249081643100369, 3.3427434470654038, 3.386001418359081, 
    4.1687598393420817, 7.7650380720250816, 3.2343108331565809, 
    4.8984957981275796, 6.5061804779596342, 5.4815909423531668, 
    3.0503306334124924, 4.9836531029316555, 5.2330439438180933, 
    4.0086377410166536, 5.0720417456107825, 3.8939168622891502, 
    1.3249081643100369, 4.0187292649310615, 2.2038607262238123, 
    1.3249081643100369, 1.5882835920230316, 4.1159365123402578, 
    5.7481814741152322, 8.2224653693445529, 6.1753469435937509, 
    4.9850950830423306, 8.114103067619503, 6.5061804779596342, 
    3.7880325351226283, 10.67644065074977, 3.1444884722373452, 
    2.8309037305795317)), row.names = c(5L, 6L, 26L, 52L, 109L, 
160L, 163L, 188L, 205L, 207L, 211L, 213L, 244L, 261L, 289L, 330L, 
333L, 345L, 385L, 421L, 422L, 479L, 519L, 533L, 540L, 547L, 555L, 
557L, 561L, 568L, 569L, 573L, 574L, 576L, 577L, 581L, 583L, 588L, 
596L, 597L, 599L, 600L, 604L, 608L, 609L, 618L, 624L, 625L, 626L, 
627L, 631L, 632L, 634L, 635L, 640L, 645L, 648L, 650L, 652L, 654L, 
657L, 660L, 661L, 663L, 664L, 675L, 709L, 792L, 797L, 801L, 817L, 
821L, 853L, 856L, 955L, 966L, 1086L, 1127L, 1129L, 1148L, 1155L, 
1162L, 1164L, 1167L, 1172L, 1176L, 1178L, 1180L, 1181L, 1186L, 
1189L, 1194L, 1196L, 1198L, 1203L, 1204L, 1207L, 1247L, 1268L, 
1357L, 1376L, 1416L, 1462L, 1545L, 1566L, 1660L, 1690L, 1697L, 
1712L, 1740L, 1741L, 1753L, 1757L, 1796L, 1817L, 1832L, 1872L, 
1883L, 1894L, 1895L, 1903L, 1942L, 2027L, 2036L, 2055L, 2069L, 
2079L, 2086L, 2095L, 2102L, 2106L, 2107L, 2108L, 2109L, 2110L, 
2113L, 2114L, 2141L, 2157L, 2175L, 2202L, 2207L, 2210L, 2251L, 
2256L, 2274L, 2275L, 2315L, 2321L, 2322L, 2331L, 2332L, 2370L, 
2373L, 2377L, 2378L, 2380L, 2384L, 2387L, 2442L, 2455L, 2477L, 
2479L, 2485L, 2493L, 2499L, 2504L, 2529L, 2626L, 2630L, 2631L, 
2643L, 2677L, 2711L, 2720L, 2726L, 2734L, 2736L, 2737L, 2739L, 
2743L, 2745L, 2746L, 2748L, 2749L, 2753L, 2754L, 2811L, 2838L, 
2872L, 2902L, 2912L, 2956L, 2975L, 2983L, 2984L, 2986L, 2988L, 
2991L, 3036L, 3068L, 3070L, 3099L, 3104L, 3121L, 3188L, 3194L, 
3195L, 3233L, 3284L, 3348L, 3451L, 3459L, 3607L, 3665L, 3693L, 
3708L, 3709L, 3721L, 3761L, 3843L, 3861L, 3864L, 3866L, 3868L, 
3981L, 3985L, 4026L, 4135L, 4139L, 4155L, 4178L, 4279L, 4282L, 
4329L, 4508L, 4573L, 4707L, 4734L, 4754L, 4755L, 4758L, 4759L, 
4760L, 4810L, 4825L, 4829L, 4830L, 5058L, 5148L, 5150L, 5170L, 
5175L, 5178L, 5190L, 5200L, 5213L, 5220L, 5223L, 5231L, 5240L, 
5241L, 5242L, 5246L, 5251L, 5259L, 5262L, 5270L, 5275L, 5279L, 
5303L, 5308L, 5311L, 5387L, 5410L, 5461L, 5462L, 5464L, 5466L, 
5475L, 5479L, 5480L, 5482L, 5485L, 5491L, 5495L, 5496L, 5498L, 
5500L, 5512L, 5572L, 5590L, 5593L, 5618L, 5653L, 5797L, 5801L, 
5806L, 5815L, 5819L, 5822L, 5917L, 5935L, 5936L, 5938L, 5945L, 
5949L, 5954L, 5956L, 5958L, 5959L, 5967L, 5973L, 5975L, 5978L, 
5988L, 5993L, 6039L, 6040L, 6041L, 6103L, 6104L, 6110L, 6138L, 
6147L, 6149L, 6170L, 6172L, 6173L, 6174L, 6183L, 6190L, 6242L, 
6243L, 6418L, 6425L, 6427L, 6431L, 6432L, 6433L, 6435L, 6436L, 
6448L, 6457L, 6462L, 6464L, 6466L, 6467L, 6473L, 6475L, 6479L, 
6507L, 6513L, 6516L, 6624L, 6663L, 6719L, 6977L, 7033L, 7041L, 
7112L, 7127L, 7173L, 7181L, 7182L, 7183L, 7185L, 7190L, 7191L, 
7199L, 7200L, 7202L, 7204L, 7207L, 7212L, 7214L, 7225L, 7226L, 
7230L, 7237L, 7399L, 7408L, 7418L, 7420L, 7421L, 7424L, 7466L, 
7488L, 7507L, 7512L, 7574L, 7575L, 7609L, 7613L, 7614L, 7615L, 
7616L, 7620L, 7648L, 7649L, 7652L, 7653L, 7659L, 7766L, 7868L, 
7869L, 7870L, 7898L, 7963L, 8050L, 8061L, 8064L, 8092L, 8127L, 
8259L, 8263L, 8269L, 8271L, 8342L, 8343L, 8357L, 8359L, 8420L, 
8436L, 8516L, 8518L, 8613L, 8627L, 8649L, 8669L, 8674L, 8675L, 
8676L, 8693L, 8761L, 8766L, 8768L, 8770L, 8785L, 8786L, 8793L, 
8799L, 8808L, 8845L, 8879L, 8923L, 8937L, 9006L, 9013L, 9096L, 
9188L, 9203L, 9297L, 9310L, 9436L, 9440L, 9442L, 9443L, 9449L, 
9450L, 9451L, 9453L, 9458L, 9464L, 9469L, 9473L, 9474L, 9475L, 
9477L, 9478L, 9479L, 9483L, 9578L, 9591L, 9592L, 9637L, 9638L, 
9725L, 9726L, 9901L, 9935L, 10108L, 10178L, 10201L, 10255L, 10267L, 
10272L, 10284L, 10525L, 10532L, 10533L, 10535L, 10536L, 10544L, 
10614L, 10618L, 10627L, 10645L, 10650L, 10652L, 10657L, 10668L, 
10678L, 10723L, 10762L, 10808L, 10820L, 10861L, 10878L, 10879L, 
10880L, 10882L, 10883L, 10884L, 10886L, 10888L, 10889L, 10909L, 
10917L, 11053L, 11086L, 11101L, 11119L, 11149L, 11155L, 11169L, 
11181L, 11212L, 11216L, 11218L, 11242L, 11259L, 11435L, 11437L, 
11455L, 11457L, 11471L, 11526L, 11571L, 11572L, 11581L, 11642L, 
11677L, 11697L, 11703L, 11710L, 11711L, 11775L, 11887L, 11909L, 
12046L, 12047L, 12093L, 12184L, 12252L, 12371L, 12445L, 12502L, 
12543L, 12595L, 12599L, 12600L, 12604L, 12610L, 12612L, 12686L, 
12747L, 13068L, 13078L, 13111L, 13204L, 13351L, 13368L, 13370L, 
13373L, 13375L, 13378L, 13431L, 13556L, 13571L, 13647L, 13687L, 
13755L, 13778L, 13780L, 13837L, 13882L, 13883L, 13918L, 13932L, 
13994L, 14051L, 14183L, 14252L, 14279L, 14306L, 14307L, 14323L, 
14332L, 14338L, 14393L, 14411L, 14416L, 14445L, 14475L, 14563L, 
14645L, 14735L, 14747L, 14794L, 14900L, 14981L, 15122L, 15173L, 
15210L, 15291L, 15452L, 15500L, 15613L, 15621L, 15652L, 15711L, 
15752L, 15857L, 15900L, 15978L, 15982L, 16064L, 16085L, 16106L, 
16115L, 16118L, 16158L, 16194L, 16195L, 16272L, 16313L, 16314L, 
16387L, 16487L, 16491L, 16498L, 16609L, 16670L, 16764L, 16797L, 
16810L, 16811L, 16845L, 16940L, 16943L, 16949L, 17027L, 17093L, 
17132L, 17133L, 17134L, 17174L, 17344L, 17348L, 17357L, 17358L, 
17364L, 17607L, 17800L, 17895L, 17958L, 17959L, 18054L, 18057L, 
18117L, 18137L, 18172L, 18318L, 18423L, 18540L, 18714L, 18751L, 
18777L, 18790L, 18837L, 18985L, 18988L, 19015L, 19068L, 19156L, 
19212L, 19390L, 19472L, 19497L, 19543L, 19546L, 19548L, 19605L, 
19613L, 19662L, 19827L, 19965L, 19976L, 19998L, 20039L, 20084L
), class = "data.frame", n1 = 1177, n2 = 341805, m = 20109L)

######################################################################
##

n1 <- attr(MRSAKeywords, "n1") # sample sizes
n2 <- attr(MRSAKeywords, "n2")
m <- attr(MRSAKeywords, "m")   # family size (to correct for multiple testing)

compare.keyness <- function (measure, gold, name="", alpha=NULL, lambda=1) {
  keyness.values <- keyness(MRSAKeywords$f1, n1, MRSAKeywords$f2, n2, 
                            measure=measure, p.adjust=m, alpha=alpha, lambda=lambda)
  reference.implementation <- MRSAKeywords[[gold]]
  res <- all.equal(keyness.values, reference.implementation)
  if (!isTRUE(res)) {
    stop("keyness() doesn't match reference implementation for ", name, "\n", res)
  }
  cat(sprintf(" - keyness scores correct for %s\n", name))
}

compare.keyness("G2", "G2", name="log-likelihood (G2)")
compare.keyness("LogRatio", "LogRatio", name="LogRatio")
compare.keyness("LogRatio", "LogRatio.G2", name="LogRatio with G2 significance filter", alpha=.05)
compare.keyness("LRC", "LRC", name="LRC (conservative LogRatio)")
compare.keyness("PositiveLRC", "LRC.positive", name="Positive LRC")
compare.keyness("SimpleMaths", "SM", name="Simple Maths", lambda=100)

